/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.wiqlparse;

import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.DataType;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.IExternal;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.NodeFieldName;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.NodeItem;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.NodeTableName;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.NodeType;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.SyntaxError;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.Tools;

public class NodeVariable
extends NodeItem {
    private DataType dataType;
    private Object tag;

    public NodeVariable(String value) {
        super(NodeType.VARIABLE, value);
    }

    @Override
    public void bind(IExternal e, NodeTableName tableContext, NodeFieldName fieldContext) {
        if (e != null) {
            this.tag = e.findVariable(this.getValue());
            Tools.ensureSyntax(this.tag != null, SyntaxError.VARIABLE_DOES_NOT_EXIST, this);
            this.dataType = e.getVariableDataType(this.tag);
            Tools.ensureSyntax(this.dataType != DataType.UNKNOWN, SyntaxError.UNKNOWN_VARIABLE_TYPE, this);
        }
        super.bind(e, tableContext, fieldContext);
    }

    @Override
    public void appendTo(StringBuffer b) {
        b.append("@" + this.getValue());
    }

    @Override
    public DataType getDataType() {
        return this.dataType;
    }

    @Override
    public boolean isConst() {
        return true;
    }

    public Object getTag() {
        return this.tag;
    }
}

