/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.wiqlparse;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.clients.workitem.WorkItemClient;
import com.microsoft.tfs.core.clients.workitem.fields.FieldDefinition;
import com.microsoft.tfs.core.clients.workitem.fields.FieldType;
import com.microsoft.tfs.core.clients.workitem.fields.FieldUsages;
import com.microsoft.tfs.core.clients.workitem.internal.InternalWorkItemUtils;
import com.microsoft.tfs.core.clients.workitem.internal.WITContext;
import com.microsoft.tfs.core.clients.workitem.internal.fields.FieldDefinitionImpl;
import com.microsoft.tfs.core.clients.workitem.internal.node.NodeImpl;
import com.microsoft.tfs.core.clients.workitem.internal.query.DisplayFieldListImpl;
import com.microsoft.tfs.core.clients.workitem.internal.query.SortFieldListImpl;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.Arithmetic;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.Condition;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.DataType;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.DateTime;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.Direction;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.IExternal;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.LinkQueryXMLResult;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.Node;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.NodeAndOperator;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.NodeArithmetic;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.NodeBoolConst;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.NodeBoolValue;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.NodeCondition;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.NodeEverOperator;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.NodeFieldList;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.NodeFieldName;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.NodeItem;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.NodeMode;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.NodeName;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.NodeNotOperator;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.NodeNumber;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.NodeOrOperator;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.NodeSelect;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.NodeString;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.NodeTableName;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.NodeType;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.NodeValueList;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.NodeVariable;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.SyntaxError;
import com.microsoft.tfs.core.clients.workitem.internal.wiqlparse.Tools;
import com.microsoft.tfs.core.clients.workitem.link.Topology;
import com.microsoft.tfs.core.clients.workitem.link.WorkItemLinkTypeEnd;
import com.microsoft.tfs.core.clients.workitem.query.DisplayFieldList;
import com.microsoft.tfs.core.clients.workitem.query.SortFieldList;
import com.microsoft.tfs.core.clients.workitem.query.SortType;
import com.microsoft.tfs.core.clients.workitem.queryhierarchy.LinkQueryMode;
import com.microsoft.tfs.core.exceptions.NotSupportedException;
import com.microsoft.tfs.util.xml.DOMCreateUtils;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Pattern;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WIQLAdapter
implements IExternal {
    private static final String[] operators = new String[48];
    private static final SortType[] sortTypes;
    private static final String ME = "me";
    private static final String TODAY = "today";
    private Map<String, Object> context;
    private final WITContext witContext;
    private boolean dayPrecision;

    public WIQLAdapter(WITContext witContext) {
        this.witContext = witContext;
    }

    @Override
    public Object findField(String name, String prefix, Object tableTag) {
        if (this.witContext.getClient().getFieldDefinitions().contains(name) || tableTag == null) {
            return this.witContext.getClient().getFieldDefinitions().get(name);
        }
        throw new RuntimeException(MessageFormat.format(Messages.getString("WiqlAdapter.QueryReferencesNonExistingFieldFormat"), name, prefix));
    }

    @Override
    public Object findTable(String name) {
        LinkQueryMode queryMode = WIQLAdapter.getQueryMode(new NodeTableName(name));
        if (LinkQueryMode.UNKNOWN.equals(queryMode)) {
            return null;
        }
        if (!LinkQueryMode.WORK_ITEMS.equals(queryMode) && !this.witContext.getServerInfo().isSupported("WorkItemLinks")) {
            throw new NotSupportedException(Messages.getString("WiqlAdapter.CannotCreateCustomTypesOfLinksOnThisServer"));
        }
        return queryMode;
    }

    @Override
    public Object findVariable(String name) {
        if (this.context.containsKey(name)) {
            return name;
        }
        if (ME.equalsIgnoreCase(name)) {
            return ME;
        }
        if (TODAY.equalsIgnoreCase(name)) {
            return TODAY;
        }
        if (this.witContext.getServerInfo().isSupported("WiqlEvaluationOnServer")) {
            this.context.put(name, name);
            return name;
        }
        return null;
    }

    public Date getAsOfUTC(NodeSelect nodeSelect) {
        if (nodeSelect.getAsOf() == null) {
            return null;
        }
        Date time1 = DateTime.parse(((NodeItem)nodeSelect.getAsOf()).getValue(), this.getLocale(), this.getTimeZone());
        return time1;
    }

    private String getConditionalOperator(int c, boolean not, boolean ever, Node errorNode) {
        String operator = operators[c * 4 + (ever ? 2 : 0) + (not ? 1 : 0)];
        Tools.ensureSyntax(operator != null, SyntaxError.INVALID_CONDITIONAL_OPERATOR, errorNode);
        return operator;
    }

    @Override
    public DataType getFieldDataType(Object fieldTag) {
        FieldDefinition definition = (FieldDefinition)fieldTag;
        if (definition.getID() == 100) {
            return DataType.STRING;
        }
        FieldType fieldType = definition.getFieldType();
        if (FieldType.STRING == fieldType || FieldType.PLAINTEXT == fieldType || FieldType.HTML == fieldType || FieldType.TREEPATH == fieldType || FieldType.HISTORY == fieldType) {
            return DataType.STRING;
        }
        if (FieldType.INTEGER == fieldType || FieldType.DOUBLE == fieldType) {
            return DataType.NUMERIC;
        }
        if (FieldType.DATETIME == fieldType) {
            return DataType.DATE;
        }
        if (FieldType.GUID == fieldType) {
            return DataType.GUID;
        }
        if (FieldType.BOOLEAN == fieldType) {
            return DataType.BOOL;
        }
        return DataType.UNKNOWN;
    }

    public static LinkQueryMode getQueryMode(NodeSelect nodeSelect) {
        return WIQLAdapter.getQueryMode(nodeSelect.getMode(), nodeSelect.getFrom());
    }

    private static LinkQueryMode getQueryMode(NodeMode nodeMode, NodeTableName tableContext) {
        LinkQueryMode queryMode = WIQLAdapter.getQueryMode(tableContext);
        if (nodeMode == null) {
            return queryMode;
        }
        Tools.ensureSyntax(queryMode.getValue() > LinkQueryMode.WORK_ITEMS.getValue(), SyntaxError.MODE_ON_WORK_ITEMS, nodeMode);
        int mask = 0;
        Iterator<Node> it = nodeMode.iterator();
        while (it.hasNext()) {
            String keyword = ((NodeName)it.next()).getValue();
            if ("MustContain".equalsIgnoreCase(keyword)) {
                mask |= 1;
                continue;
            }
            if ("MayContain".equalsIgnoreCase(keyword)) {
                mask |= 2;
                continue;
            }
            if ("DoesNotContain".equalsIgnoreCase(keyword)) {
                mask |= 4;
                continue;
            }
            if ("Recursive".equalsIgnoreCase(keyword)) {
                mask |= 8;
                continue;
            }
            mask = -1;
        }
        switch (mask) {
            case 0: 
            case 1: {
                return LinkQueryMode.LINKS_MUST_CONTAIN;
            }
            case 2: {
                return LinkQueryMode.LINKS_MAY_CONTAIN;
            }
            case 4: {
                return LinkQueryMode.LINKS_DOES_NOT_CONTAIN;
            }
            case 8: 
            case 9: {
                return LinkQueryMode.LINKS_RECURSIVE;
            }
        }
        return LinkQueryMode.UNKNOWN;
    }

    private static LinkQueryMode getQueryMode(NodeTableName tableContext) {
        String from = tableContext.getValue();
        if (from != null) {
            if ("issue".equalsIgnoreCase(from) || "issues".equalsIgnoreCase(from) || "workitem".equalsIgnoreCase(from) || "WorkItems".equalsIgnoreCase(from)) {
                return LinkQueryMode.WORK_ITEMS;
            }
            if ("links".equalsIgnoreCase(from) || "WorkItemLinks".equalsIgnoreCase(from)) {
                return LinkQueryMode.LINKS_MUST_CONTAIN;
            }
        }
        return LinkQueryMode.UNKNOWN;
    }

    public Element getQueryXML(NodeSelect nodeSelect) {
        LinkQueryMode mode = (LinkQueryMode)nodeSelect.getFrom().getTag();
        Tools.ensureSyntax(LinkQueryMode.WORK_ITEMS == mode, SyntaxError.INCORRECT_QUERY_METHOD, nodeSelect.getFrom());
        Document document = DOMCreateUtils.newDocument("Query");
        Element queryXmlElement = document.getDocumentElement();
        queryXmlElement.setAttribute("Product", this.witContext.getProductValue());
        Node whereNode = nodeSelect.getWhere();
        if (whereNode == null) {
            whereNode = new NodeBoolConst(true);
        }
        queryXmlElement.appendChild(this.queryXML(whereNode, queryXmlElement.getOwnerDocument(), false, false, false));
        Date asOf = this.getAsOfUTC(nodeSelect);
        if (asOf != null) {
            SimpleDateFormat externalDateFormat = InternalWorkItemUtils.newMetadataDateFormat();
            queryXmlElement.setAttribute("AsOf", externalDateFormat.format(asOf));
        }
        return queryXmlElement;
    }

    public Element getQueryXML(String wiql, Map<String, Object> context, boolean isLinkQuery, boolean dayPrecision) {
        Document document = DOMCreateUtils.newDocument(isLinkQuery ? "LinksQuery" : "Query");
        Element queryXml = document.getDocumentElement();
        queryXml.setAttribute("Product", "");
        Element wx = document.createElement("Wiql");
        wx.appendChild(document.createTextNode(wiql));
        queryXml.appendChild(wx);
        Element dx = document.createElement("DayPrecision");
        dx.appendChild(document.createTextNode(dayPrecision ? "true" : "false"));
        queryXml.appendChild(dx);
        if (context != null) {
            context.remove("currentIteration");
            for (Map.Entry<String, Object> entry : context.entrySet()) {
                if (entry.getKey() == null || entry.getValue() == null) continue;
                Element cx = document.createElement("Context");
                cx.setAttribute("Key", entry.getKey());
                cx.setAttribute("Value", entry.getValue().toString());
                cx.setAttribute("ValueType", this.GetContextValueType(entry.getValue()));
                queryXml.appendChild(cx);
            }
        }
        return queryXml;
    }

    public LinkQueryXMLResult getLinkQueryXML(NodeSelect nodeSelect) {
        Date asOf;
        LinkQueryMode mode = (LinkQueryMode)nodeSelect.getFrom().getTag();
        String type = null;
        if (LinkQueryMode.LINKS_MUST_CONTAIN.equals(mode)) {
            type = "mustcontain";
        } else if (LinkQueryMode.LINKS_RECURSIVE.equals(mode) || LinkQueryMode.LINKS_MAY_CONTAIN.equals(mode)) {
            type = "maycontain";
        } else if (LinkQueryMode.LINKS_DOES_NOT_CONTAIN.equals(mode)) {
            type = "doesnotcontain";
        } else {
            Tools.ensureSyntax(false, SyntaxError.INCORRECT_QUERY_METHOD, nodeSelect.getFrom());
        }
        Document document = DOMCreateUtils.newDocument("LinksQuery");
        Element queryXmlElement = document.getDocumentElement();
        queryXmlElement.setAttribute("Type", type);
        Map<String, NodeAndOperator> groups = nodeSelect.getWhereGroups();
        NodeAndOperator leftGroup = groups.get("Source");
        if (leftGroup != null) {
            Element x = queryXmlElement.getOwnerDocument().createElement("LeftQuery");
            x.appendChild(this.queryXML(leftGroup, queryXmlElement.getOwnerDocument(), false, false, false));
            queryXmlElement.appendChild(x);
        }
        NodeAndOperator linkGroup = groups.get("");
        if (mode == LinkQueryMode.LINKS_RECURSIVE) {
            Tools.ensureSyntax(linkGroup != null, SyntaxError.TREE_QUERY_NEEDS_ONE_LINK_TYPE, linkGroup);
            Map<Integer, Boolean> types = this.computeLinkTypes(linkGroup);
            Tools.ensureSyntax(types.size() == 1, SyntaxError.TREE_QUERY_NEEDS_ONE_LINK_TYPE, linkGroup);
            queryXmlElement.setAttribute("RecursionID", types.keySet().toArray()[0].toString());
        } else if (linkGroup != null) {
            Element x = queryXmlElement.getOwnerDocument().createElement("LinkQuery");
            x.appendChild(this.queryXML(linkGroup, queryXmlElement.getOwnerDocument(), false, false, false));
            queryXmlElement.appendChild(x);
        }
        NodeAndOperator rightGroup = groups.get("Target");
        if (rightGroup != null) {
            Element x = queryXmlElement.getOwnerDocument().createElement("RightQuery");
            x.appendChild(this.queryXML(rightGroup, queryXmlElement.getOwnerDocument(), false, false, false));
            queryXmlElement.appendChild(x);
        }
        if ((asOf = this.getAsOfUTC(nodeSelect)) != null) {
            SimpleDateFormat externalDateFormat = InternalWorkItemUtils.newMetadataDateFormat();
            queryXmlElement.setAttribute("AsOf", externalDateFormat.format(asOf));
        }
        return new LinkQueryXMLResult(queryXmlElement, linkGroup);
    }

    public DisplayFieldList getDisplayFieldList(WITContext witContext, NodeSelect nodeSelect) {
        DisplayFieldListImpl list = new DisplayFieldListImpl(witContext);
        NodeFieldList fields = nodeSelect.getFields();
        if (fields != null) {
            Iterator<Node> it = fields.iterator();
            while (it.hasNext()) {
                NodeFieldName field = (NodeFieldName)it.next();
                list.add(((FieldDefinitionImpl)field.getTag()).getReferenceName());
            }
        } else if (LinkQueryMode.WORK_ITEMS.equals(nodeSelect.getFrom().getTag())) {
            for (FieldDefinition fd : witContext.getFieldDefinitions()) {
                if (fd.getUsage() != FieldUsages.WORK_ITEM) continue;
                list.add(fd);
            }
        } else {
            witContext.getFieldDefinitions().getFieldDefinitionInternal(-3);
            witContext.getFieldDefinitions().getFieldDefinitionInternal(100);
        }
        return list;
    }

    public SortFieldList getSortFieldList(WITContext witContext, NodeSelect nodeSelect) {
        SortFieldListImpl list = new SortFieldListImpl(witContext);
        NodeFieldList fields = nodeSelect.getOrderBy();
        if (fields != null) {
            Iterator<Node> iterator = fields.iterator();
            while (iterator.hasNext()) {
                NodeFieldName field = (NodeFieldName)iterator.next();
                SortType sortType = field.getDirection() == Direction.DESCENDING ? SortType.DESCENDING : SortType.ASCENDING;
                list.add((FieldDefinition)field.getTag(), sortType);
            }
        }
        return list;
    }

    public Map<Integer, Boolean> computeLinkTypes(Node node) {
        if (node.getNodeType() == NodeType.FIELD_CONDITION) {
            NodeCondition cond = (NodeCondition)node;
            NodeFieldName field = cond.getLeft();
            FieldDefinition fd = (FieldDefinition)field.getTag();
            if (fd.getID() == 100) {
                WorkItemLinkTypeEnd linkTypeEnd = this.getLinkTypeByName(cond.getRight().getConstStringValue());
                Tools.ensureSyntax(linkTypeEnd != null, SyntaxError.INVALID_LINK_TYPE_NAME, cond.getRight());
                if (cond.getCondition() == Condition.EQUALS) {
                    HashMap<Integer, Boolean> linkTypes = new HashMap<Integer, Boolean>();
                    linkTypes.put(new Integer(linkTypeEnd.getID()), Boolean.TRUE);
                    return linkTypes;
                }
                if (cond.getCondition() == Condition.NOT_EQUALS) {
                    HashMap<Integer, Boolean> linkTypes = new HashMap<Integer, Boolean>();
                    for (WorkItemLinkTypeEnd t : this.witContext.getClient().getLinkTypes().getLinkTypeEnds()) {
                        if (t.getID() == linkTypeEnd.getID()) continue;
                        linkTypes.put(new Integer(t.getID()), Boolean.TRUE);
                    }
                    return linkTypes;
                }
                Tools.ensureSyntax(false, SyntaxError.INVALID_CONDITION_FOR_LINK_TYPE, cond);
            }
            return null;
        }
        if (node.getNodeType() == NodeType.AND) {
            NodeAndOperator and = (NodeAndOperator)node;
            Map<Integer, Boolean> linkTypes = null;
            for (int i = 0; i < and.getCount(); ++i) {
                Map<Integer, Boolean> map = this.computeLinkTypes(and.getItem(i));
                if (linkTypes == null) {
                    linkTypes = map;
                    continue;
                }
                if (map == null) continue;
                HashMap<Integer, Boolean> retMap = new HashMap<Integer, Boolean>();
                for (Integer t : map.keySet()) {
                    if (!linkTypes.containsKey(t)) continue;
                    retMap.put(t, Boolean.TRUE);
                }
                linkTypes = retMap;
            }
            return linkTypes;
        }
        if (node.getNodeType() == NodeType.NOT) {
            NodeNotOperator not = (NodeNotOperator)node;
            Map<Integer, Boolean> linkTypes = this.computeLinkTypes(not.getValue());
            if (linkTypes != null) {
                HashMap<Integer, Boolean> ret = new HashMap<Integer, Boolean>();
                for (WorkItemLinkTypeEnd t : this.witContext.getClient().getLinkTypes().getLinkTypeEnds()) {
                    if (!linkTypes.containsKey(new Integer(t.getID()))) {
                        // empty if block
                    }
                    ret.put(new Integer(t.getID()), Boolean.TRUE);
                }
                return ret;
            }
            return null;
        }
        Tools.ensureSyntax(false, SyntaxError.INVALID_CONDITION_FOR_LINK_TYPE, node);
        return null;
    }

    private int getTreeID(String path, int nodeStructureType) {
        NodeImpl targetNode = this.witContext.getRootNode().findNodeDownwards(path, false, nodeStructureType);
        if (targetNode == null) {
            return -1;
        }
        return targetNode.getID();
    }

    @Override
    public DataType getVariableDataType(Object variableTag) {
        Object object;
        if (this.context != null && (object = this.context.get(variableTag)) != null) {
            if (object instanceof Date) {
                return DataType.DATE;
            }
            if (object instanceof Integer || object instanceof Double) {
                return DataType.NUMERIC;
            }
            return DataType.STRING;
        }
        if (ME.equals(variableTag)) {
            return DataType.STRING;
        }
        if (TODAY.equals(variableTag)) {
            return DataType.DATE;
        }
        if ("currentIteration".equals(variableTag)) {
            return DataType.STRING;
        }
        return DataType.UNKNOWN;
    }

    private String GetContextValueType(Object val) {
        if (val instanceof Date) {
            return "DateTime";
        }
        if (val instanceof Integer) {
            return "Number";
        }
        if (val instanceof Double) {
            return "Double";
        }
        return "String";
    }

    @Override
    public Node optimizeNode(Node node, NodeTableName tableContext, NodeFieldName fieldContext) {
        if (node.getNodeType() == NodeType.FIELD_CONDITION) {
            String rightString;
            String s;
            String pathValue;
            String s2;
            NodeCondition nodeCondition = (NodeCondition)node;
            if (nodeCondition.getCondition() == Condition.IN) {
                NodeOrOperator nodeOr = new NodeOrOperator();
                NodeValueList valueList = (NodeValueList)nodeCondition.getRight();
                Iterator<Node> it = valueList.iterator();
                while (it.hasNext()) {
                    Node valueItem = it.next();
                    nodeOr.add(new NodeCondition(Condition.EQUALS, nodeCondition.getLeft(), valueItem));
                }
                return nodeOr.optimize(this, tableContext, fieldContext);
            }
            if ((nodeCondition.getCondition() == Condition.CONTAINS || nodeCondition.getCondition() == Condition.CONTAINS_WORDS) && (s2 = nodeCondition.getRight().getConstStringValue()) != null && s2.length() == 0) {
                return new NodeBoolConst(true);
            }
            NodeFieldName field = nodeCondition.getLeft();
            FieldDefinitionImpl fd = (FieldDefinitionImpl)field.getTag();
            if (fd.getID() == -42 && (pathValue = nodeCondition.getRight().getConstStringValue()) != null) {
                FieldDefinitionImpl pathField = this.witContext.getFieldDefinitions().getFieldDefinitionInternal(-7);
                node = new NodeCondition(Condition.UNDER, new NodeFieldName(field.getPrefix(), pathField.getName()), new NodeString(pathValue));
                if (nodeCondition.getCondition() == Condition.NOT_EQUALS) {
                    node = new NodeNotOperator(node);
                }
                node.bind(this, tableContext, fieldContext);
            }
            if (WIQLAdapter.isNonNullableField(fd.getID()) && (s = nodeCondition.getRight().getConstStringValue()) != null && s.length() == 0 && nodeCondition.getCondition() == Condition.NOT_EQUALS) {
                return new NodeBoolConst(true);
            }
            if (this.dayPrecision && field.getDataType() == DataType.DATE && (rightString = nodeCondition.getRight().getConstStringValue()) != null && rightString.length() != 0) {
                Date d = DateTime.parse(rightString, this.getLocale(), this.getTimeZone());
                Calendar calendar = Calendar.getInstance();
                calendar.setTimeZone(this.getTimeZone());
                calendar.setTime(d);
                boolean nonZeroTime = calendar.get(11) != 0 || calendar.get(12) != 0 || calendar.get(13) != 0 || calendar.get(14) != 0;
                Tools.ensureSyntax(!nonZeroTime, SyntaxError.NON_ZERO_TIME, node);
                NodeString startDay = new NodeString(DateTime.formatRoundTripLocal(d, this.getTimeZone()));
                Calendar c = Calendar.getInstance();
                c.setTime(d);
                c.setTimeZone(this.getTimeZone());
                c.add(5, 1);
                d = c.getTime();
                NodeString nextDay = new NodeString(DateTime.formatRoundTripLocal(d, this.getTimeZone()));
                if (nodeCondition.getCondition() == Condition.EQUALS) {
                    NodeAndOperator nodeAnd = new NodeAndOperator();
                    nodeAnd.add(new NodeCondition(Condition.GREATER_OR_EQUALS, nodeCondition.getLeft(), startDay));
                    nodeAnd.add(new NodeCondition(Condition.LESS, nodeCondition.getLeft(), nextDay));
                    node = nodeAnd;
                    node.bind(this, tableContext, fieldContext);
                } else if (nodeCondition.getCondition() == Condition.NOT_EQUALS) {
                    NodeOrOperator nodeOr = new NodeOrOperator();
                    nodeOr.add(new NodeCondition(Condition.LESS, nodeCondition.getLeft(), startDay));
                    nodeOr.add(new NodeCondition(Condition.GREATER_OR_EQUALS, nodeCondition.getLeft(), nextDay));
                    node = nodeOr;
                    node.bind(this, tableContext, fieldContext);
                } else if (nodeCondition.getCondition() == Condition.LESS || nodeCondition.getCondition() == Condition.GREATER_OR_EQUALS) {
                    nodeCondition.setRight(startDay);
                } else if (nodeCondition.getCondition() == Condition.GREATER) {
                    nodeCondition.setCondition(Condition.GREATER_OR_EQUALS);
                    nodeCondition.setRight(nextDay);
                } else if (nodeCondition.getCondition() == Condition.LESS_OR_EQUALS) {
                    nodeCondition.setCondition(Condition.LESS);
                    nodeCondition.setRight(nextDay);
                } else {
                    Tools.ensureSyntax(false, SyntaxError.INVALID_CONDITIONAL_OPERATOR, node);
                }
            }
        } else if (node.getNodeType() == NodeType.VARIABLE) {
            Object o;
            NodeVariable nodeVariable = (NodeVariable)node;
            if (this.context != null && (o = this.context.get(nodeVariable.getTag())) != null) {
                if (o instanceof Integer || o instanceof Double) {
                    return new NodeNumber(o.toString());
                }
                return new NodeString(o.toString());
            }
            if (ME.equals(nodeVariable.getTag())) {
                return new NodeString(this.witContext.getCurrentUserDisplayName());
            }
            if (TODAY.equals(nodeVariable.getTag())) {
                Date today = DateTime.today(this.getTimeZone());
                return new NodeString(DateTime.formatRoundTripLocal(today, this.getTimeZone()));
            }
        } else if (node.getNodeType() == NodeType.ARITHMETIC) {
            NodeArithmetic a = (NodeArithmetic)node;
            NodeNumber right = (NodeNumber)a.getRight();
            if (fieldContext == null || fieldContext.getDataType() == DataType.NUMERIC) {
                NodeNumber left = (NodeNumber)a.getLeft();
                double d = Double.parseDouble(left.getValue());
                double inc = Double.parseDouble(right.getValue());
                if (a.getArithmetic() == Arithmetic.ADD) {
                    d += inc;
                } else if (a.getArithmetic() == Arithmetic.SUBTRACT) {
                    d -= inc;
                } else {
                    throw new RuntimeException();
                }
                return new NodeNumber(String.valueOf(d));
            }
            if (fieldContext != null && fieldContext.getDataType() == DataType.DATE) {
                NodeString left = (NodeString)a.getLeft();
                Date d = DateTime.parse(left.getValue(), this.getLocale(), this.getTimeZone());
                boolean isIntegerDays = false;
                int integerDays = -1;
                try {
                    integerDays = Integer.parseInt(right.getValue());
                    isIntegerDays = true;
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
                if (isIntegerDays) {
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(d);
                    calendar.setTimeZone(this.getTimeZone());
                    if (a.getArithmetic() == Arithmetic.ADD) {
                        calendar.add(5, integerDays);
                    } else if (a.getArithmetic() == Arithmetic.SUBTRACT) {
                        calendar.add(5, -1 * integerDays);
                    } else {
                        throw new UnsupportedOperationException();
                    }
                    d = calendar.getTime();
                } else {
                    double doubleDays = Double.parseDouble(right.getValue());
                    long millis = (long)(doubleDays * 8.64E7 + 0.5);
                    if (a.getArithmetic() == Arithmetic.ADD) {
                        d = new Date(d.getTime() + millis);
                    } else if (a.getArithmetic() == Arithmetic.SUBTRACT) {
                        d = new Date(d.getTime() - millis);
                    } else {
                        throw new UnsupportedOperationException();
                    }
                }
                return new NodeString(DateTime.formatRoundTripLocal(d, this.getTimeZone()));
            }
        }
        return node;
    }

    private Element queryXML(Node node, Document doc, boolean not, boolean ever, boolean num) {
        if (node.getNodeType() == NodeType.FIELD_NAME) {
            FieldDefinition fd = (FieldDefinition)((NodeFieldName)node).getTag();
            Element element = doc.createElement("Column");
            element.appendChild(doc.createTextNode(fd.getReferenceName()));
            return element;
        }
        if (node.getNodeType() == NodeType.STRING) {
            Element element = doc.createElement("String");
            element.appendChild(doc.createTextNode(((NodeString)node).getValue()));
            return element;
        }
        if (node.getNodeType() == NodeType.NUMBER) {
            Element element = doc.createElement(num ? "Number" : "String");
            element.appendChild(doc.createTextNode(((NodeNumber)node).getValue()));
            return element;
        }
        if (node.getNodeType() == NodeType.BOOL_VALUE) {
            Element element = doc.createElement("Number");
            element.appendChild(doc.createTextNode(((NodeBoolValue)node).getBoolValue() ? "1" : "0"));
            return element;
        }
        if (node.getNodeType() == NodeType.FIELD_CONDITION) {
            int treeId;
            String path;
            NodeCondition cond = (NodeCondition)node;
            NodeFieldName field = cond.getLeft();
            FieldDefinition fd = (FieldDefinition)field.getTag();
            int fieldType = ((FieldDefinitionImpl)fd).getPSType();
            Node right = cond.getRight();
            if (fd.getID() == -7) {
                path = right.getConstStringValue();
                fd = this.witContext.getClient().getFieldDefinitions().get("System.AreaId");
                if (path.length() != 0) {
                    treeId = this.getTreeID(path, 1);
                    Tools.ensureSyntax(treeId != -1, SyntaxError.TREE_PATH_IS_NOT_FOUND_IN_HIERARCHY, right);
                    right = new NodeNumber(String.valueOf(treeId));
                }
            } else if (fd.getID() == -105) {
                path = right.getConstStringValue();
                Tools.ensureSyntax(path != null, SyntaxError.EXPECTING_VALUE, right);
                fd = this.witContext.getClient().getFieldDefinitions().get("System.IterationId");
                if (path.length() != 0) {
                    treeId = this.getTreeID(path, 2);
                    Tools.ensureSyntax(treeId != -1, SyntaxError.TREE_PATH_IS_NOT_FOUND_IN_HIERARCHY, right);
                    right = new NodeNumber(String.valueOf(treeId));
                }
            } else if (fd.getID() == 100) {
                WorkItemLinkTypeEnd linkTypeEnd = this.getLinkTypeByName(right.getConstStringValue());
                Tools.ensureSyntax(linkTypeEnd != null, SyntaxError.INVALID_LINK_TYPE_NAME, right);
                right = new NodeNumber(String.valueOf(linkTypeEnd.getID()));
            }
            Element x = doc.createElement("Expression");
            x.setAttribute("Column", fd.getReferenceName());
            x.setAttribute("FieldType", String.valueOf(fieldType));
            if (cond.getCondition() == Condition.CONTAINS || cond.getCondition() == Condition.CONTAINS_WORDS) {
                int c = cond.getCondition().getValue();
                String pattern = cond.getRight().getConstStringValue();
                if (fd.getID() == 54) {
                    ever = true;
                }
                x.setAttribute("Operator", this.getConditionalOperator(c, not, ever, cond));
                Element xpat = doc.createElement("String");
                xpat.appendChild(doc.createTextNode(pattern));
                x.appendChild(xpat);
            } else if (cond.getCondition() == Condition.GROUP) {
                x.setAttribute("Operator", this.getConditionalOperator(cond.getCondition().getValue(), not, ever, cond));
                x.setAttribute("ExpandConstant", "true");
                String groupName = cond.getRight().getConstStringValue();
                Element xmlGroupElement = doc.createElement("String");
                xmlGroupElement.appendChild(doc.createTextNode(groupName));
                x.appendChild(xmlGroupElement);
            } else {
                x.setAttribute("Operator", this.getConditionalOperator(cond.getCondition().getValue(), not, ever, cond));
                if (right.getNodeType() == NodeType.FIELD_NAME) {
                    x.appendChild(this.queryXML(right, doc, not, ever, false));
                } else if (field.getDataType() == DataType.DATE) {
                    String s = right.getConstStringValue();
                    Tools.ensureSyntax(s != null, SyntaxError.EXPECTING_VALUE, right);
                    if (s.length() != 0) {
                        Date dt = DateTime.parse(s, this.getLocale(), this.getTimeZone());
                        s = DateTime.formatRoundTripUniversal(dt);
                    }
                    Element xdt = doc.createElement("DateTime");
                    xdt.appendChild(doc.createTextNode(s));
                    x.appendChild(xdt);
                } else if (field.getDataType() == DataType.GUID) {
                    Element xdt = doc.createElement("Guid");
                    xdt.appendChild(doc.createTextNode(right.getConstStringValue()));
                    x.appendChild(xdt);
                } else {
                    num = fd.getFieldType() == FieldType.INTEGER;
                    x.appendChild(this.queryXML(right, doc, not, ever, num));
                }
            }
            return x;
        }
        if (node.getNodeType() == NodeType.AND || node.getNodeType() == NodeType.OR) {
            String op = node.getNodeType() == NodeType.OR == not ? "and" : "or";
            Element x = doc.createElement("Group");
            x.setAttribute("GroupOperator", op);
            int c = node.getCount();
            for (int i = 0; i < c; ++i) {
                x.appendChild(this.queryXML(node.getItem(i), doc, not, ever, num));
            }
            return x;
        }
        if (node.getNodeType() == NodeType.NOT) {
            return this.queryXML(((NodeNotOperator)node).getValue(), doc, !not, ever, num);
        }
        if (node.getNodeType() == NodeType.EVER) {
            return this.queryXML(((NodeEverOperator)node).getValue(), doc, not, true, num);
        }
        if (node.getNodeType() == NodeType.BOOL_CONST) {
            String op = ((NodeBoolConst)node).getValue() == not ? "equals" : "notequals";
            Element x = doc.createElement("Expression");
            x.setAttribute("Column", "System.Id");
            x.setAttribute("Operator", op);
            Element x0 = doc.createElement("Number");
            x0.appendChild(doc.createTextNode("0"));
            x.appendChild(x0);
            return x;
        }
        Tools.ensureSyntax(false, SyntaxError.INVALID_NODE_TYPE, node);
        return null;
    }

    private void verifyCondition(NodeFieldName left, Node right, Condition op, Node errorNode, LinkQueryMode mode) {
        Tools.ensureSyntax(op != Condition.NONE, SyntaxError.INVALID_CONDITIONAL_OPERATOR, errorNode);
        FieldDefinition fd = (FieldDefinition)left.getTag();
        if (NodeType.FIELD_NAME.equals(right.getNodeType())) {
            if (!this.witContext.getServerInfo().isSupported("QueryFieldsComparison")) {
                throw new NotSupportedException(Messages.getString("WiqlAdapter.CannotRunQueryThatComparesFieldsOnThisServer"));
            }
            if (LinkQueryMode.LINKS_MUST_CONTAIN.equals(mode) || LinkQueryMode.LINKS_MAY_CONTAIN.equals(mode) || LinkQueryMode.LINKS_DOES_NOT_CONTAIN.equals(mode) || LinkQueryMode.LINKS_RECURSIVE.equals(mode)) {
                Tools.ensureSyntax(left.getPrefix().equalsIgnoreCase(((NodeFieldName)right).getPrefix()), SyntaxError.FIELD_CONDITIONS_IN_LINK_QUERIES, errorNode);
            }
            Tools.ensureSyntax(!FieldType.PLAINTEXT.equals(fd.getFieldType()) && !FieldType.HTML.equals(fd.getFieldType()) && !FieldType.HISTORY.equals(fd.getFieldType()), SyntaxError.INVALID_FIELD_TYPE_FOR_CONDITION, errorNode);
            FieldDefinition rfd = (FieldDefinition)((NodeFieldName)right).getTag();
            Tools.ensureSyntax(!FieldType.PLAINTEXT.equals(rfd.getFieldType()) && !FieldType.HTML.equals(rfd.getFieldType()) && !FieldType.HISTORY.equals(rfd.getFieldType()), SyntaxError.INVALID_FIELD_TYPE_FOR_CONDITION, errorNode);
            return;
        }
        String rightString = right.getConstStringValue();
        if (op == Condition.IN) {
            NodeValueList valueList = (NodeValueList)right;
            Iterator<Node> it = valueList.iterator();
            while (it.hasNext()) {
                this.verifyCondition(left, it.next(), Condition.EQUALS, errorNode, mode);
            }
            return;
        }
        if (op == Condition.GROUP) {
            if (fd.getID() == 25) {
                if (!this.witContext.getServerInfo().isSupported("WorkItemTypeCategories")) {
                    throw new NotSupportedException(Messages.getString("WiqlAdapter.CannotCreateCategoriesOfWorkItemsOnThisServer"));
                }
            } else {
                if (!this.witContext.getServerInfo().isSupported("QueryInGroup")) {
                    throw new NotSupportedException(Messages.getString("WiqlAdapter.CannotUseInGroupOperatorToRunQueryOnThisServer"));
                }
                if (!FieldType.STRING.equals(fd.getFieldType())) {
                    throw new NotSupportedException(MessageFormat.format(Messages.getString("WiqlAdapter.CannotUseInGroupOperatorWithFieldOnThisServerFormat"), fd.getName(), "String"));
                }
            }
        }
        if (rightString != null && rightString.length() == 0) {
            Tools.ensureSyntax(op == Condition.EQUALS || op == Condition.NOT_EQUALS, SyntaxError.INVALID_CONDITION_FOR_EMPTY_STRING, errorNode);
        }
        if (FieldType.TREEPATH == fd.getFieldType()) {
            Tools.ensureSyntax(op == Condition.EQUALS || op == Condition.NOT_EQUALS || op == Condition.UNDER, SyntaxError.INVALID_CONDITION_FOR_TREE_FIELD, errorNode);
            Tools.ensureSyntax(right.getDataType() == DataType.STRING, SyntaxError.PATH_MUST_BE_A_STRING_NOT_STARTING_WITH_BACKSLASH, right);
            if (rightString != null && (rightString.length() != 0 || op == Condition.UNDER)) {
                Tools.ensureSyntax(!rightString.startsWith("\\"), SyntaxError.PATH_MUST_BE_A_STRING_NOT_STARTING_WITH_BACKSLASH, right);
                int type = fd.getID() == -7 ? 1 : 2;
                Tools.ensureSyntax(this.getTreeID(rightString, type) != -1, SyntaxError.TREE_PATH_IS_NOT_FOUND_IN_HIERARCHY, right);
            }
        } else if (FieldType.PLAINTEXT == fd.getFieldType() || FieldType.HISTORY == fd.getFieldType() || FieldType.HTML == fd.getFieldType()) {
            if (rightString != null) {
                Tools.ensureSyntax(op == Condition.CONTAINS || op == Condition.CONTAINS_WORDS, SyntaxError.INVALID_CONDITION_FOR_LONG_TEXT_FIELD, errorNode);
                Tools.ensureSyntax(rightString.trim().length() > 0, SyntaxError.INVALID_LONG_TEXT_SEARCH_FOR_WHITESPACE, errorNode);
            }
        } else if (FieldType.STRING == fd.getFieldType() && -42 == fd.getID()) {
            Tools.ensureSyntax(op == Condition.EQUALS || op == Condition.NOT_EQUALS, SyntaxError.INVALID_CONDITION_FOR_NODE_FIELD, errorNode);
            if (rightString != null && (rightString.length() != 0 || op == Condition.UNDER)) {
                Tools.ensureSyntax(rightString.indexOf("\\") == -1, SyntaxError.INVALID_PROJECT_NAME, right);
                int treeId = this.getTreeID(rightString, 1);
                Tools.ensureSyntax(treeId != -1, SyntaxError.PROJECT_NOT_FOUND, right);
            }
        } else if (FieldType.INTEGER == fd.getFieldType() && fd.getID() == 100) {
            Tools.ensureSyntax(op == Condition.EQUALS || op == Condition.NOT_EQUALS, SyntaxError.INVALID_CONDITION_FOR_LINK_TYPE, errorNode);
            if (rightString != null && (rightString.length() != 0 || op != Condition.NOT_EQUALS)) {
                WorkItemLinkTypeEnd linkTypeEnd = this.getLinkTypeByName(rightString);
                Tools.ensureSyntax(linkTypeEnd != null, SyntaxError.INVALID_LINK_TYPE_NAME, right);
                if (LinkQueryMode.LINKS_RECURSIVE.equals(mode)) {
                    Tools.ensureSyntax(Topology.TREE == linkTypeEnd.getLinkType().getLinkTopology() && linkTypeEnd.isForwardLink(), SyntaxError.INVALID_LINK_TYPE_NAME_RECURSIVE, right);
                }
            }
        } else if (FieldType.INTEGER == fd.getFieldType() && rightString != null && rightString.length() != 0 && rightString != null && rightString.length() > 0) {
            Tools.ensureSyntax(Pattern.matches("[+-]?[0-9]+", rightString), SyntaxError.INCOMPATIBLE_RIGHT_CONST, right);
        }
        if (op == Condition.UNDER) {
            Tools.ensureSyntax(FieldType.TREEPATH == fd.getFieldType(), SyntaxError.UNDER_CAN_BE_USED_FOR_TREE_PATH_FIELD_ONLY, left);
        }
    }

    private WorkItemLinkTypeEnd getLinkTypeByName(String linkTypeName) {
        return this.witContext.getClient().getLinkTypes().getLinkTypeEnds().get(linkTypeName);
    }

    @Override
    public void verifyNode(Node node, NodeTableName tableContext, NodeFieldName fieldContext) {
        if (node.getNodeType() == NodeType.FIELD_CONDITION) {
            NodeCondition conditionNode = (NodeCondition)node;
            this.verifyCondition(conditionNode.getLeft(), conditionNode.getRight(), conditionNode.getCondition(), conditionNode, (LinkQueryMode)tableContext.getTag());
        } else if (node.getNodeType() == NodeType.EVER) {
            NodeEverOperator nodeEver = (NodeEverOperator)node;
            Tools.ensureSyntax(nodeEver.getValue().getNodeType() == NodeType.FIELD_CONDITION, SyntaxError.TOO_COMPLEX_EVER_OPERATOR, nodeEver);
            NodeCondition nodeCondition = (NodeCondition)nodeEver.getValue();
            Tools.ensureSyntax(nodeCondition.getCondition() == Condition.EQUALS || nodeCondition.getCondition() == Condition.CONTAINS || nodeCondition.getCondition() == Condition.CONTAINS_WORDS, SyntaxError.EVER_NOT_EQUAL_OPERATOR, nodeCondition);
            if (nodeCondition.getLeft().getDataType() == DataType.DATE && this.dayPrecision) {
                Tools.ensureSyntax(nodeCondition.getRight().getConstStringValue().length() == 0, SyntaxError.EVER_WITH_DATE_PRECISION, nodeCondition);
                FieldDefinition fd = (FieldDefinition)nodeCondition.getLeft().getTag();
                if (fd != null) {
                    Tools.ensureSyntax((fd.getUsage().getValue() & FieldUsages.WORK_ITEM.getValue()) != 0, SyntaxError.EVER_WITH_LINK_QUERY, node);
                }
            }
        } else if (node.getNodeType() == NodeType.FIELD_LIST) {
            Iterator<Node> it = node.iterator();
            while (it.hasNext()) {
                NodeFieldName fieldNameNode = (NodeFieldName)it.next();
                FieldDefinition tag = (FieldDefinition)fieldNameNode.getTag();
                Tools.ensureSyntax(tag.isQueryable(), SyntaxError.NON_QUERYABLE_FIELD, fieldNameNode);
            }
        } else if (node.getNodeType() == NodeType.ORDER_FIELD_LIST) {
            Iterator<Node> it = node.iterator();
            while (it.hasNext()) {
                NodeFieldName field1;
                NodeFieldName field = (NodeFieldName)it.next();
                FieldDefinition fd = (FieldDefinition)field.getTag();
                if ((fd.getUsage().getValue() & FieldUsages.WORK_ITEM_LINK.getValue()) != 0) {
                    // empty if block
                }
                Iterator<Node> it2 = node.iterator();
                while (it2.hasNext() && (field1 = (NodeFieldName)it2.next()) != field) {
                    Tools.ensureSyntax(fd != (FieldDefinition)field1.getTag(), SyntaxError.DUPLICATE_ORDER_BY_FIELD, field);
                }
                Tools.ensureSyntax(fd.isSortable(), SyntaxError.NON_SORTABLE_FIELD, field);
            }
        } else if (node.getNodeType() != NodeType.GROUP_FIELD_LIST) {
            if (node.getNodeType() == NodeType.ARITHMETIC) {
                NodeArithmetic arithmeticNode = (NodeArithmetic)node;
                Tools.ensureSyntax(arithmeticNode.getLeft().canCastTo(DataType.DATE, this.getLocale()) || arithmeticNode.getLeft().canCastTo(DataType.NUMERIC, this.getLocale()), SyntaxError.WRONG_TYPE_FOR_ARITHMETIC, node);
                Tools.ensureSyntax(arithmeticNode.getRight().getDataType() == DataType.NUMERIC, SyntaxError.WRONG_TYPE_FOR_ARITHMETIC_RIGHT_OPERAND, node);
            } else if (node.getNodeType() == NodeType.MODE) {
                NodeMode nodeMode = (NodeMode)node;
                LinkQueryMode mode = WIQLAdapter.getQueryMode(nodeMode, tableContext);
                Tools.ensureSyntax(mode != LinkQueryMode.UNKNOWN, SyntaxError.UNKNOWN_MODE, node);
                tableContext.setTag(mode);
            } else if (node.getNodeType() == NodeType.SELECT) {
                NodeSelect nodeSelect = (NodeSelect)node;
                Tools.ensureSyntax(nodeSelect.getFrom().getTag() != null, SyntaxError.EXPECTING_TABLE_NAME, nodeSelect);
                Tools.ensureSyntax(nodeSelect.getGroupBy() == null, SyntaxError.GROUP_BY_IS_NOT_SUPPORTED, nodeSelect.getGroupBy());
                if ((LinkQueryMode)nodeSelect.getFrom().getTag() == LinkQueryMode.LINKS_RECURSIVE) {
                    Tools.ensureSyntax(nodeSelect.getAsOf() == null, SyntaxError.NOT_SUPPORTED_TREE_QUERY, nodeSelect.getAsOf());
                }
            }
        }
    }

    public Map<String, Object> getContext() {
        return this.context;
    }

    public void setContext(Map<String, Object> context) {
        this.context = context;
    }

    @Override
    public Locale getLocale() {
        return this.witContext.getConnection().getLocale();
    }

    public boolean isDayPrecision() {
        return this.dayPrecision;
    }

    public void setDayPrecision(boolean dayPrecision) {
        this.dayPrecision = dayPrecision;
    }

    @Override
    public TimeZone getTimeZone() {
        return this.witContext.getConnection().getTimeZone();
    }

    public static boolean fieldSupportsAnySyntax(WorkItemClient client, String fieldName) {
        if (fieldName == null || fieldName.length() == 0) {
            return false;
        }
        FieldDefinition fd = client.getFieldDefinitions().get(fieldName);
        return fd != null && WIQLAdapter.fieldSupportsAnySyntax(fd.getID());
    }

    public static boolean fieldSupportsAnySyntax(int fieldId) {
        return WIQLAdapter.isNonNullableField(fieldId);
    }

    public static boolean isNonNullableField(int fieldId) {
        return fieldId == 25 || fieldId == 2 || fieldId == 100;
    }

    static {
        WIQLAdapter.operators[4] = "equals";
        WIQLAdapter.operators[5] = "notEquals";
        WIQLAdapter.operators[6] = "ever";
        WIQLAdapter.operators[8] = "notEquals";
        WIQLAdapter.operators[9] = "equals";
        WIQLAdapter.operators[11] = "ever";
        WIQLAdapter.operators[12] = "less";
        WIQLAdapter.operators[13] = "equalsGreater";
        WIQLAdapter.operators[16] = "greater";
        WIQLAdapter.operators[17] = "equalsLess";
        WIQLAdapter.operators[20] = "equalsLess";
        WIQLAdapter.operators[21] = "greater";
        WIQLAdapter.operators[24] = "equalsGreater";
        WIQLAdapter.operators[25] = "less";
        WIQLAdapter.operators[28] = "under";
        WIQLAdapter.operators[29] = "notUnder";
        WIQLAdapter.operators[36] = "contains";
        WIQLAdapter.operators[37] = "notContains";
        WIQLAdapter.operators[38] = "everContains";
        WIQLAdapter.operators[39] = "neverContains";
        WIQLAdapter.operators[40] = "containsWords";
        WIQLAdapter.operators[41] = "notContainsWords";
        WIQLAdapter.operators[42] = "everContainsWords";
        WIQLAdapter.operators[43] = "neverContainsWords";
        WIQLAdapter.operators[44] = "equals";
        WIQLAdapter.operators[45] = "notequals";
        sortTypes = new SortType[3];
        WIQLAdapter.sortTypes[Direction.UNKNOWN.getValue()] = SortType.ASCENDING;
        WIQLAdapter.sortTypes[Direction.ASCENDING.getValue()] = SortType.ASCENDING;
        WIQLAdapter.sortTypes[Direction.DESCENDING.getValue()] = SortType.DESCENDING;
    }
}

