/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.query.qe;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;

public abstract class WIQLHelpers {
    private static final String SINGLE_QUOTE = "'";
    private static final String TWO_SINGLE_QUOTES = "''";
    private static final String SINGLE_QUOTED_STRING_FORMAT = "''{0}''";
    private static final String DOUBLE_QUOTED_STRING_FORMAT = "\"{0}\"";
    private static final String BRACKETED_STRING_FORMAT = "[{0}]";

    public static Map<String, String> getParameterDictionary(String projectName) {
        HashMap<String, String> dict = new HashMap<String, String>();
        dict.put("project", projectName);
        return dict;
    }

    public static String getEscapedSingleQuotedValue(String value) {
        return WIQLHelpers.getSingleQuotedValue(value.replace(SINGLE_QUOTE, TWO_SINGLE_QUOTES));
    }

    public static String getSingleQuotedValue(String value) {
        return MessageFormat.format(SINGLE_QUOTED_STRING_FORMAT, value);
    }

    public static String getDoubleQuotedValue(String value) {
        return MessageFormat.format(DOUBLE_QUOTED_STRING_FORMAT, value);
    }

    public static String getEnclosedField(String value) {
        return MessageFormat.format(BRACKETED_STRING_FORMAT, value);
    }
}

