/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.credentials;

import com.microsoft.tfs.core.httpclient.Cookie;
import com.microsoft.tfs.core.httpclient.CookieCredentials;
import com.microsoft.tfs.core.httpclient.Credentials;
import com.microsoft.tfs.core.httpclient.PreemptiveUsernamePasswordCredentials;
import com.microsoft.tfs.core.httpclient.UsernamePasswordCredentials;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.StringUtil;
import java.net.URI;

public class CachedCredentials {
    private final URI uri;
    private final String username;
    private final String password;
    private final Cookie[] cookies;

    public CachedCredentials(URI uri, Credentials credentials) {
        Check.notNull(uri, "uri");
        Check.notNull(credentials, "credentials");
        this.uri = uri;
        if (credentials instanceof UsernamePasswordCredentials) {
            Check.notNull(((UsernamePasswordCredentials)credentials).getUsername(), "((UsernamePasswordCredentials) credentials).getUsername()");
            this.username = ((UsernamePasswordCredentials)credentials).getUsername();
            this.password = ((UsernamePasswordCredentials)credentials).getPassword();
            this.cookies = null;
        } else if (credentials instanceof CookieCredentials) {
            this.username = null;
            this.password = null;
            this.cookies = ((CookieCredentials)credentials).getCookies();
        } else {
            this.username = null;
            this.password = null;
            this.cookies = null;
        }
    }

    public CachedCredentials(URI uri, String username, String password) {
        Check.notNull(uri, "uri");
        this.uri = uri;
        this.username = username;
        this.password = password;
        this.cookies = null;
    }

    public CachedCredentials(URI uri, String pat) {
        Check.notNull(uri, "uri");
        this.uri = uri;
        this.username = "_VSTS_Code_Access_Token_";
        this.password = pat == null ? "" : pat;
        this.cookies = null;
    }

    public CachedCredentials(URI uri, Cookie[] cookies) {
        Check.notNull(uri, "uri");
        this.uri = uri;
        this.username = null;
        this.password = null;
        this.cookies = cookies;
    }

    public URI getURI() {
        return this.uri;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public Cookie[] getCookies() {
        return this.cookies;
    }

    public boolean isNtlmCredentials() {
        return this.cookies == null && this.username == null && this.password == null;
    }

    public boolean isCookieCredentials() {
        return this.cookies != null;
    }

    public boolean isPatCredentials() {
        return !StringUtil.isNullOrEmpty(this.password) && (StringUtil.isNullOrEmpty(this.username) || "_VSTS_Code_Access_Token_".equals(this.username));
    }

    public boolean isUsernamePasswordCredentials() {
        return !this.isCookieCredentials() && !this.isPatCredentials() && !StringUtil.isNullOrEmpty(this.username);
    }

    public Credentials toCredentials() {
        if (this.isCookieCredentials()) {
            return new CookieCredentials(this.cookies);
        }
        if (this.isPatCredentials()) {
            return new UsernamePasswordCredentials.PatCredentials(this.password);
        }
        String u = this.username != null ? this.username : "";
        return new UsernamePasswordCredentials(u, this.password);
    }

    public Credentials toPreemptiveCredentials() {
        if (this.isCookieCredentials()) {
            return new CookieCredentials(this.cookies);
        }
        if (this.isPatCredentials()) {
            return PreemptiveUsernamePasswordCredentials.newFrom(new UsernamePasswordCredentials.PatCredentials(this.password));
        }
        String u = this.username != null ? this.username : "";
        return new PreemptiveUsernamePasswordCredentials(u, this.password);
    }

    public int hashCode() {
        int result = 17;
        result = result * 37 + this.uri.hashCode();
        result = result * 37 + (this.username != null ? this.username.hashCode() : 0);
        result = result * 37 + (this.password != null ? this.password.hashCode() : 0);
        result = result * 37 + (this.cookies != null ? this.cookies.hashCode() : 0);
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CachedCredentials)) {
            return false;
        }
        CachedCredentials other = (CachedCredentials)obj;
        if (this.cookies == null && other.cookies == null) {
            return this.uri.equals(other.uri) && (this.username == other.username || this.username != null && this.username.equals(other.username)) && (this.password == other.password || this.password != null && this.password.equals(other.password));
        }
        if (this.cookies != null && other.cookies != null) {
            if (this.cookies.length != other.cookies.length) {
                return false;
            }
            for (int k = 0; k < this.cookies.length; ++k) {
                if (this.cookies[k].equals(other.cookies[k])) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

