/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.credentials.internal;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.credentials.CachedCredentials;
import com.microsoft.tfs.core.credentials.CredentialsManager;
import com.microsoft.tfs.core.util.URIUtils;
import com.microsoft.tfs.jni.WinCredential;
import com.microsoft.tfs.jni.WinCredentialUtils;
import com.microsoft.tfs.util.Check;
import java.net.URI;

public class WinCredentialsManager
implements CredentialsManager {
    @Override
    public String getUIMechanismName() {
        return Messages.getString("WinCredentialsManager.CredentialManager");
    }

    @Override
    public boolean canWrite() {
        return true;
    }

    @Override
    public boolean isSecure() {
        return true;
    }

    @Override
    public CachedCredentials[] getCredentials() {
        return null;
    }

    @Override
    public CachedCredentials getCredentials(URI serverURI) {
        Check.notNull(serverURI, "serverURI");
        URI uri = URIUtils.removePathAndQueryParts(serverURI);
        WinCredential credential = WinCredentialUtils.getInstance().findCredential(WinCredentialsManager.newWinCredentialFromURI(uri));
        if (credential == null) {
            return null;
        }
        String username = credential.getAccountName();
        String password = credential.getPassword();
        return new CachedCredentials(uri, username, password);
    }

    @Override
    public boolean setCredentials(CachedCredentials cachedCredentials) {
        Check.notNull(cachedCredentials, "cachedCredentials");
        Check.notNull(cachedCredentials.getURI(), "cachedCredentials.getURI()");
        URI serverURI = URIUtils.removePathAndQueryParts(cachedCredentials.getURI());
        cachedCredentials = new CachedCredentials(serverURI, cachedCredentials.getUsername(), cachedCredentials.getPassword());
        WinCredential credential = WinCredentialsManager.newWinCredentialFromURI(serverURI);
        credential.setAccountName(cachedCredentials.getUsername());
        if (cachedCredentials.getPassword() != null) {
            credential.setPassword(cachedCredentials.getPassword());
        }
        return WinCredentialUtils.getInstance().storeCredential(credential);
    }

    @Override
    public boolean removeCredentials(CachedCredentials cachedCredentials) {
        Check.notNull(cachedCredentials, "cachedCredentials");
        Check.notNull(cachedCredentials.getURI(), "cachedCredentials.getURI()");
        return this.removeCredentials(cachedCredentials.getURI());
    }

    @Override
    public boolean removeCredentials(URI uri) {
        Check.notNull(uri, "uri");
        URI serverURI = URIUtils.removePathAndQueryParts(uri);
        WinCredential credential = WinCredentialsManager.newWinCredentialFromURI(serverURI);
        return WinCredentialUtils.getInstance().eraseCredential(credential);
    }

    private static WinCredential newWinCredentialFromURI(URI uri) {
        Check.notNull(uri, "uri");
        WinCredential credential = new WinCredential();
        if (uri.getHost() != null && uri.getHost().length() > 0) {
            credential.setServerUri(uri.getHost());
        }
        return credential;
    }
}

