/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.exceptions.mappers;

import com.microsoft.tfs.core.clients.versioncontrol.exceptions.ActionDeniedBySubscriberException;
import com.microsoft.tfs.core.clients.versioncontrol.exceptions.PathTooLongException;
import com.microsoft.tfs.core.clients.versioncontrol.exceptions.ReconcileBlockedByProjectRenameException;
import com.microsoft.tfs.core.clients.versioncontrol.exceptions.ResourceAccessException;
import com.microsoft.tfs.core.clients.versioncontrol.exceptions.TeamFoundationServerExceptionProperties;
import com.microsoft.tfs.core.clients.versioncontrol.exceptions.VersionControlException;
import com.microsoft.tfs.core.clients.versioncontrol.exceptions.WorkspaceNotFoundException;
import com.microsoft.tfs.core.exceptions.mappers.TECoreExceptionMapper;
import com.microsoft.tfs.core.ws.runtime.exceptions.SOAPFault;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class VersionControlExceptionMapper
extends TECoreExceptionMapper {
    public static RuntimeException map(RuntimeException e) {
        RuntimeException betterException;
        if (e instanceof SOAPFault && (betterException = VersionControlExceptionMapper.mapSoapFault((SOAPFault)e)) != e) {
            return betterException;
        }
        return TECoreExceptionMapper.map(e);
    }

    private static RuntimeException mapSoapFault(SOAPFault soapFault) {
        Node detailNode = soapFault.getDetail();
        if (detailNode != null) {
            VersionControlException newException = null;
            String subCode = soapFault.getSubCode().getSubCode().getLocalPart();
            if (subCode.equals("ActionDeniedBySubscriberException")) {
                newException = new ActionDeniedBySubscriberException(soapFault.getMessage());
            } else if (subCode.equals("WorkspaceNotFoundException")) {
                newException = new WorkspaceNotFoundException(soapFault.getMessage(), soapFault);
            } else if (subCode.equals("ResourceAccessException")) {
                newException = new ResourceAccessException(soapFault.getMessage(), soapFault);
            } else if (subCode.equals("ReconcileBlockedByProjectRenameException")) {
                newException = new ReconcileBlockedByProjectRenameException(soapFault.getMessage(), soapFault);
            } else if (subCode.equals("PathTooLongException")) {
                newException = new VersionControlException(new PathTooLongException(detailNode.getAttributes().getNamedItem("ExceptionMessage").toString()));
            }
            if (newException != null) {
                TeamFoundationServerExceptionProperties properties = VersionControlExceptionMapper.readProperties(detailNode);
                newException.setProperties(properties);
                return newException;
            }
        }
        return soapFault;
    }

    private static TeamFoundationServerExceptionProperties readProperties(Node detailNode) {
        Element detailElement;
        NodeList nodes;
        if (detailNode.getNodeType() == 1 && (nodes = (detailElement = (Element)detailNode).getElementsByTagName("ExceptionProperties")) != null && nodes.getLength() > 0) {
            return new TeamFoundationServerExceptionProperties((Element)nodes.item(0));
        }
        return null;
    }
}

