/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.httpclient.auth;

import com.microsoft.tfs.core.httpclient.Credentials;
import com.microsoft.tfs.core.httpclient.Header;
import com.microsoft.tfs.core.httpclient.HttpMethod;
import com.microsoft.tfs.core.httpclient.HttpState;
import com.microsoft.tfs.core.httpclient.auth.AuthScheme;
import com.microsoft.tfs.core.httpclient.auth.AuthScope;
import com.microsoft.tfs.core.httpclient.auth.AuthenticationException;

public abstract class AuthorizationHeaderScheme
implements AuthScheme {
    public static final String HOST_CHALLENGE_HEADER = "WWW-Authenticate";
    public static final String HOST_RESPONSE_HEADER = "Authorization";
    public static final String PROXY_CHALLENGE_HEADER = "Proxy-Authenticate";
    public static final String PROXY_RESPONSE_HEADER = "Proxy-Authorization";

    @Override
    public void authenticateHost(AuthScope authScope, Credentials credentials, HttpState state, HttpMethod method) throws AuthenticationException {
        String authString = this.authenticate(authScope, credentials, method);
        if (authString != null) {
            method.addRequestHeader(new Header(HOST_RESPONSE_HEADER, authString, true));
        }
    }

    @Override
    public void authenticateProxy(AuthScope authScope, Credentials credentials, HttpState state, HttpMethod method) throws AuthenticationException {
        String authString = this.authenticate(authScope, credentials, method);
        if (authString != null) {
            method.addRequestHeader(new Header(PROXY_RESPONSE_HEADER, authString, true));
        }
    }

    protected abstract String authenticate(AuthScope var1, Credentials var2, HttpMethod var3) throws AuthenticationException;
}

