/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.pendingcheckin.filters;

import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.PendingChange;
import com.microsoft.tfs.core.pendingcheckin.filters.PendingChangeFilter;
import com.microsoft.tfs.util.Check;
import java.util.regex.Pattern;

public class ScopeFilter
implements PendingChangeFilter {
    public static final int EXPRESSION_FLAGS = 64;
    private final Pattern[] patterns;

    public ScopeFilter(String[] scopeExpressions) {
        Check.notNull(scopeExpressions, "scopeExpressions");
        this.patterns = new Pattern[scopeExpressions.length];
        for (int i = 0; i < scopeExpressions.length; ++i) {
            this.patterns[i] = Pattern.compile(scopeExpressions[i], 64);
        }
    }

    @Override
    public boolean passes(PendingChange change) {
        return this.passes(change.getServerItem());
    }

    public boolean passes(String serverPath) {
        return this.passesWhich(serverPath) != -1;
    }

    public int passesWhich(String serverPath) {
        if (this.patterns.length == 0) {
            return Integer.MIN_VALUE;
        }
        for (int i = 0; i < this.patterns.length; ++i) {
            if (!this.patterns[i].matcher(serverPath).matches()) continue;
            return i;
        }
        return -1;
    }
}

