/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.util;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.clients.versioncontrol.path.LocalPath;
import com.microsoft.tfs.core.clients.versioncontrol.path.ServerPath;
import com.microsoft.tfs.core.clients.versioncontrol.path.Wildcard;
import com.microsoft.tfs.core.exceptions.TECoreException;
import com.microsoft.tfs.core.util.CodePageMapping;
import com.microsoft.tfs.core.util.FileEncoding;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.IOUtils;
import com.microsoft.tfs.util.Platform;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.text.MessageFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class FileEncodingDetector {
    private static final Log tracer = LogFactory.getLog(FileEncodingDetector.class);

    private FileEncodingDetector() {
    }

    public static FileEncoding detectEncoding(String path, FileEncoding encodingHint) {
        tracer.trace((Object)MessageFormat.format("path={0}, encodingHint={1}", path, encodingHint));
        Check.notNull(path, "path");
        Check.notNull(encodingHint, "encodingHint");
        if (encodingHint == FileEncoding.BINARY) {
            return encodingHint;
        }
        if (encodingHint == FileEncoding.DEFAULT_TEXT) {
            return FileEncoding.getDefaultTextEncoding();
        }
        if (encodingHint != FileEncoding.AUTOMATICALLY_DETECT) {
            return encodingHint;
        }
        if (ServerPath.isServerPath(path)) {
            throw new TECoreException(MessageFormat.format(Messages.getString("FileEncodingDetector.ServerPathsNotDetectedFormat"), path));
        }
        if (Wildcard.isWildcard(path)) {
            throw new TECoreException(MessageFormat.format(Messages.getString("FileEncodingDetector.LocalItemContainsWildcardsFormat"), path));
        }
        File file = new File(LocalPath.canonicalize(path));
        if (!file.exists()) {
            throw new TECoreException(MessageFormat.format(Messages.getString("FileEncodingDetector.LocalItemDoesNotExistFormat"), path));
        }
        if (file.isDirectory()) {
            throw new TECoreException(MessageFormat.format(Messages.getString("FileEncodingDetector.LocalItemIsDirectoryFormat"), path));
        }
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(path);
            byte[] buffer = new byte[1024];
            int read = stream.read(buffer, 0, buffer.length);
            if (read < 0) {
                FileEncoding fileEncoding = FileEncoding.getDefaultTextEncoding();
                return fileEncoding;
            }
            if (read >= 2 && buffer[0] == -2 && buffer[1] == -1) {
                FileEncoding fileEncoding = FileEncoding.UTF_16BE;
                return fileEncoding;
            }
            if (read >= 2 && buffer[0] == -1 && buffer[1] == -2) {
                if (read >= 4 && buffer[2] == 0 && buffer[3] == 0) {
                    FileEncoding fileEncoding = FileEncoding.UTF_32;
                    return fileEncoding;
                }
                FileEncoding fileEncoding = FileEncoding.UTF_16;
                return fileEncoding;
            }
            if (read >= 3 && buffer[0] == -17 && buffer[1] == -69 && buffer[2] == -65) {
                FileEncoding fileEncoding = FileEncoding.UTF_8;
                return fileEncoding;
            }
            if (read >= 4 && buffer[0] == 0 && buffer[1] == 0 && buffer[2] == -2 && buffer[3] == -1) {
                FileEncoding fileEncoding = FileEncoding.UTF_32BE;
                return fileEncoding;
            }
            if (FileEncodingDetector.startsWithPDFHeader(buffer, buffer.length)) {
                FileEncoding fileEncoding = FileEncoding.BINARY;
                return fileEncoding;
            }
            if (Platform.isCurrentPlatform(Platform.Z_OS)) {
                if (!FileEncodingDetector.looksLikeEBCDIC(buffer, read)) {
                    FileEncoding fileEncoding = FileEncoding.BINARY;
                    return fileEncoding;
                }
            } else if (!FileEncodingDetector.looksLikeANSI(buffer, read)) {
                FileEncoding fileEncoding = FileEncoding.BINARY;
                return fileEncoding;
            }
            FileEncoding fileEncoding = FileEncoding.getDefaultTextEncoding();
            return fileEncoding;
        }
        catch (IOException e) {
            throw new TECoreException(e);
        }
        finally {
            if (stream != null) {
                IOUtils.closeSafely(stream);
            }
        }
    }

    private static boolean startsWithPDFHeader(byte[] bytes, int size) {
        byte[] firstFive;
        if (size < 8) {
            return false;
        }
        try {
            firstFive = "%PDF-".getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        for (int i = 0; i < firstFive.length; ++i) {
            if (firstFive[i] == bytes[i]) continue;
            return false;
        }
        return Character.isDigit((char)bytes[5]) && bytes[6] == 46 && Character.isDigit((char)bytes[7]);
    }

    protected static boolean looksLikeANSI(byte[] bytes, int limit) {
        Charset charSet = CodePageMapping.getCharset(FileEncoding.getDefaultTextEncoding().getCodePage());
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes, 0, limit);
        CharBuffer charBuffer = CharBuffer.allocate(limit);
        CharsetDecoder decoder = charSet.newDecoder();
        decoder.onUnmappableCharacter(CodingErrorAction.REPORT);
        decoder.onMalformedInput(CodingErrorAction.REPORT);
        CoderResult rc = decoder.decode(byteBuffer, charBuffer, true);
        if (!rc.isError()) {
            return true;
        }
        return byteBuffer.position() > limit - 5;
    }

    protected static boolean looksLikeEBCDIC(byte[] bytes, int limit) {
        for (int i = 0; i < limit; ++i) {
            if (bytes[i] < 0 || bytes[i] > 62 || bytes[i] == 5 || bytes[i] == 6 || bytes[i] == 9 || bytes[i] == 11 || bytes[i] == 12 || bytes[i] == 13 || bytes[i] == 21 || bytes[i] == 37 || bytes[i] == 56 || bytes[i] == 57) continue;
            return false;
        }
        return true;
    }
}

