/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.util.serverlist;

import com.microsoft.tfs.core.util.ServerURIComparator;
import com.microsoft.tfs.core.util.ServerURIUtils;
import com.microsoft.tfs.core.util.serverlist.ServerListEntryType;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.LocaleInvariantStringHelpers;
import java.net.URI;

public abstract class ServerListEntry {
    private final String name;
    private final ServerListEntryType type;
    private final URI uri;

    public ServerListEntry(String name, ServerListEntryType type, URI uri) {
        Check.notNullOrEmpty(name, "name");
        Check.notNull(type, "type");
        Check.notNull(uri, "uri");
        this.name = name;
        this.type = type;
        this.uri = uri;
    }

    public String getName() {
        return this.name;
    }

    public ServerListEntryType getType() {
        return this.type;
    }

    public URI getURI() {
        return this.uri;
    }

    public int compareTo(ServerListEntry other) {
        Check.notNull(other, "other");
        int result = this.name.compareTo(other.name);
        if (result != 0) {
            return result;
        }
        result = ServerURIComparator.INSTANCE.compare(this.uri, other.uri);
        return result;
    }

    public int hashCode() {
        int result = 17;
        result = result * 37 + (this.name == null ? 0 : LocaleInvariantStringHelpers.caseInsensitiveHashCode(this.name));
        result = result * 37 + (this.type == null ? 0 : this.type.getValue());
        result = result * 37 + (this.uri == null ? 0 : LocaleInvariantStringHelpers.caseInsensitiveHashCode(ServerURIUtils.normalizeURI(this.uri).toString()));
        return result;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof ServerListEntry)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        ServerListEntry other = (ServerListEntry)o;
        if (this.name != null && other.name != null && this.name.equalsIgnoreCase(other.name)) {
            return false;
        }
        if (this.name != null ^ other.name != null) {
            return false;
        }
        if (this.type != null && other.type != null && !this.type.equals(other.type)) {
            return false;
        }
        if (this.type != null ^ other.type != null) {
            return false;
        }
        if (this.uri != null && other.uri != null && ServerURIComparator.INSTANCE.compare(this.uri, other.uri) != 0) {
            return false;
        }
        return !(this.uri != null ^ other.uri != null);
    }
}

