/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.util.serverlist.internal;

import com.microsoft.tfs.core.persistence.LockMode;
import com.microsoft.tfs.core.persistence.PersistenceStore;
import com.microsoft.tfs.core.util.serverlist.ServerList;
import com.microsoft.tfs.core.util.serverlist.ServerListManager;
import com.microsoft.tfs.core.util.serverlist.internal.ServerListSerializer;
import com.microsoft.tfs.util.Check;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PersistenceStoreServerListManager
implements ServerListManager {
    private static final Log log = LogFactory.getLog(PersistenceStoreServerListManager.class);
    private static final String CHILD_STORE_NAME = "TEE-Servers";
    private static final String OBJECT_NAME = "Servers.xml";
    private final PersistenceStore configurationStore;

    public PersistenceStoreServerListManager(PersistenceStore configurationStore) {
        Check.notNull(configurationStore, "configurationStore");
        this.configurationStore = configurationStore;
    }

    @Override
    public ServerList getServerList() {
        return this.load();
    }

    @Override
    public boolean setServerList(ServerList serverList) {
        Check.notNull(serverList, "serverList");
        try {
            this.save(serverList);
            return true;
        }
        catch (Exception e) {
            log.warn((Object)"Unable to save servers list", (Throwable)e);
            return false;
        }
    }

    private ServerList load() {
        PersistenceStore currentStore = this.configurationStore.getChildStore(CHILD_STORE_NAME);
        try {
            if (!currentStore.containsItem(OBJECT_NAME)) {
                return new ServerList();
            }
            ServerList serverList = (ServerList)currentStore.retrieveItem(OBJECT_NAME, LockMode.WAIT_FOREVER, null, new ServerListSerializer());
            if (serverList == null) {
                return new ServerList();
            }
            return serverList;
        }
        catch (Exception e) {
            log.warn((Object)"Unable to load servers list", (Throwable)e);
            return new ServerList();
        }
    }

    private boolean save(ServerList serverList) {
        Check.notNull(serverList, "serverList");
        try {
            return this.configurationStore.getChildStore(CHILD_STORE_NAME).storeItem(OBJECT_NAME, serverList, LockMode.WAIT_FOREVER, null, new ServerListSerializer());
        }
        catch (Exception e) {
            log.warn((Object)"Unable to save servers list", (Throwable)e);
            return false;
        }
    }
}

