/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.ws.runtime.util;

import com.microsoft.tfs.util.Check;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PrimitiveArrayHelpers {
    public static Object toArray(Collection collection, Class componentType) {
        Check.notNull(collection, "collection");
        Check.notNull(componentType, "componentType");
        if (!componentType.isPrimitive()) {
            throw new IllegalArgumentException("the specified component type [" + componentType.getName() + "] is not primitive");
        }
        Object array = Array.newInstance(componentType, collection.size());
        int ix = 0;
        for (Object currentComponent : collection) {
            Array.set(array, ix++, currentComponent);
        }
        return array;
    }

    public static List asList(Object primitiveArray) {
        Check.notNull(primitiveArray, "primitiveArray");
        if (!primitiveArray.getClass().isArray() || !primitiveArray.getClass().getComponentType().isPrimitive()) {
            throw new IllegalArgumentException("the input argument is not a primitive array");
        }
        int size = Array.getLength(primitiveArray);
        ArrayList<Object> list = new ArrayList<Object>(size);
        for (int i = 0; i < size; ++i) {
            Object obj = Array.get(primitiveArray, i);
            list.add(obj);
        }
        return list;
    }
}

