/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.jni.appleforked.stream;

import com.microsoft.tfs.jni.appleforked.fileformat.AppleForkedConstants;
import com.microsoft.tfs.jni.appleforked.fileformat.AppleForkedEntryDescriptor;
import com.microsoft.tfs.jni.appleforked.fileformat.AppleForkedHeader;
import com.microsoft.tfs.jni.appleforked.stream.encoder.AppleForkedEntryDescriptorArrayEncoder;
import com.microsoft.tfs.jni.appleforked.stream.encoder.AppleForkedHeaderEncoder;
import com.microsoft.tfs.jni.appleforked.stream.encoder.entry.AppleForkedEntryEncoder;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.chunkingcodec.ChunkedEncoder;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;

public abstract class AppleForkedEncoderStream
extends InputStream {
    private final int magic;
    private int version = 131072;
    private String filesystem = null;
    private final File inputFile;
    private boolean configured = false;
    private boolean complete = false;
    private int index = 0;
    private AppleForkedHeaderEncoder headerEncoder;
    private AppleForkedEntryDescriptor[] entryDescriptor;
    private AppleForkedEntryDescriptorArrayEncoder descriptorArrayEncoder;
    private AppleForkedEntryEncoder[] entryEncoder;

    protected AppleForkedEncoderStream(File file, int magic) {
        Check.notNull(file, "file");
        this.magic = magic;
        this.inputFile = file;
    }

    protected AppleForkedEncoderStream(String filename, int magic) {
        Check.notNull(filename, "filename");
        this.magic = magic;
        this.inputFile = new File(filename);
    }

    public final void setVersion(int version) {
        this.version = version;
    }

    public final void setFilesystem(String filesystem) {
        this.filesystem = filesystem;
    }

    protected abstract AppleForkedEntryEncoder[] configureEncoders(File var1);

    @Override
    public final int read() throws IOException {
        byte[] readBytes = new byte[1];
        if (this.read(readBytes, 0, 1) < 0) {
            return -1;
        }
        return readBytes[0] & 0xFF;
    }

    @Override
    public final int read(byte[] buf, int off, int len) throws IOException {
        int readlen = 0;
        if (!this.configured) {
            this.configure();
        }
        if (this.complete) {
            return -1;
        }
        while (readlen < len && !this.complete) {
            int passlen;
            if (!this.headerEncoder.isComplete()) {
                passlen = this.headerEncoder.encode(buf, off + readlen, len - readlen);
            } else if (!this.descriptorArrayEncoder.isComplete()) {
                passlen = this.descriptorArrayEncoder.encode(buf, off + readlen, len - readlen);
            } else {
                AppleForkedEntryDescriptor currentDescriptor = null;
                ChunkedEncoder currentEncoder = null;
                long nextOffset = -1L;
                for (int i = 0; i < this.entryDescriptor.length; ++i) {
                    if ((long)this.index >= this.entryDescriptor[i].getOffset() && (long)this.index < this.entryDescriptor[i].getOffset() + this.entryDescriptor[i].getLength()) {
                        currentDescriptor = this.entryDescriptor[i];
                        currentEncoder = this.entryEncoder[i];
                        break;
                    }
                    if ((long)this.index >= this.entryDescriptor[i].getOffset() || this.entryDescriptor[i].getOffset() >= nextOffset) continue;
                    nextOffset = this.entryDescriptor[i].getOffset();
                }
                if (currentDescriptor != null) {
                    if (currentEncoder.isComplete()) {
                        throw new IOException(MessageFormat.format("Buffer underrun on entry {0}", Long.toString(currentDescriptor.getType())));
                    }
                    passlen = currentEncoder.encode(buf, off + readlen, len - readlen);
                } else if (nextOffset > 0L) {
                    passlen = (int)Math.min(nextOffset - (long)this.index, (long)(len - readlen));
                } else {
                    this.complete = true;
                    passlen = 0;
                }
            }
            readlen += passlen;
            this.index += passlen;
        }
        if (readlen == 0 && this.complete) {
            return -1;
        }
        return readlen;
    }

    private void configure() throws IOException {
        this.entryEncoder = this.configureEncoders(this.inputFile);
        if (this.entryEncoder == null) {
            throw new IOException(MessageFormat.format("No entry encoders found for {0} file", AppleForkedConstants.getNameFromMagic(this.magic)));
        }
        AppleForkedHeader header = new AppleForkedHeader(this.magic, this.version, this.filesystem, this.entryEncoder.length);
        this.headerEncoder = new AppleForkedHeaderEncoder(header);
        this.entryDescriptor = new AppleForkedEntryDescriptor[this.entryEncoder.length];
        long nextOffset = 26 + 12 * this.entryEncoder.length;
        for (int i = 0; i < this.entryEncoder.length; ++i) {
            long entryLength = this.entryEncoder[i].getLength();
            this.entryDescriptor[i] = new AppleForkedEntryDescriptor(this.entryEncoder[i].getType(), nextOffset, entryLength);
            nextOffset += entryLength;
        }
        this.descriptorArrayEncoder = new AppleForkedEntryDescriptorArrayEncoder(this.entryDescriptor);
        this.configured = true;
    }

    @Override
    public final void close() throws IOException {
        if (this.entryEncoder != null) {
            boolean complete = true;
            for (int i = 0; i < this.entryEncoder.length; ++i) {
                if (!this.entryEncoder[i].isComplete()) {
                    complete = false;
                }
                this.entryEncoder[i].close();
            }
            if (!complete) {
                throw new IOException(MessageFormat.format("Incomplete {0} file", AppleForkedConstants.getNameFromMagic(this.magic)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }
}

