/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.jni.appleforked.stream.decoder.entry;

import com.microsoft.tfs.jni.appleforked.fileformat.AppleForkedEntryDescriptor;
import com.microsoft.tfs.jni.appleforked.stream.decoder.entry.AppleForkedEntryDecoder;
import com.microsoft.tfs.util.Check;

public class AppleForkedNullEntryDecoder
implements AppleForkedEntryDecoder {
    private final long entrySize;
    private long entryLen;

    public AppleForkedNullEntryDecoder(AppleForkedEntryDescriptor descriptor) {
        Check.notNull(descriptor, "descriptor");
        this.entrySize = descriptor.getLength();
    }

    @Override
    public int decode(byte[] buf, int off, int len) {
        int writeLen = (int)Math.min(this.entrySize - this.entryLen, (long)len);
        this.entryLen += (long)writeLen;
        return writeLen;
    }

    @Override
    public boolean isComplete() {
        return this.entryLen == this.entrySize;
    }

    @Override
    public void close() {
    }
}

