/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.util;

import com.microsoft.tfs.util.Check;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;

public class MRUSet
extends LinkedHashSet<String> {
    private static final long serialVersionUID = -7846787297390071357L;
    private final int maxSize;

    public MRUSet(int maxSize) {
        Check.isTrue(maxSize > 0, "maxSize > 0");
        this.maxSize = maxSize;
    }

    @Override
    public boolean add(String element) {
        Check.notNull(element, "element");
        int index = this.indexOf(element);
        if (index != -1) {
            this.remove(element);
            super.add(element);
            return index != this.size() - 1;
        }
        if (this.size() >= this.maxSize) {
            Iterator iterator = this.iterator();
            this.remove(iterator.next());
        }
        super.add(element);
        return true;
    }

    private int indexOf(String element) {
        Check.notNull(element, "element");
        int pos = 0;
        Iterator i = this.iterator();
        while (i.hasNext()) {
            if (element.equals(i.next())) {
                return pos;
            }
            ++pos;
        }
        return -1;
    }

    @Override
    public boolean addAll(Collection<? extends String> c) {
        Check.notNull(c, "c");
        Object[] oldValues = this.toArray(new String[this.size()]);
        Iterator<? extends String> iterator = c.iterator();
        while (iterator.hasNext()) {
            this.add(iterator.next());
        }
        if (oldValues.length != this.size()) {
            return true;
        }
        return !Arrays.equals(oldValues, this.toArray(new String[this.size()]));
    }
}

