/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.util.chunkingcodec;

import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.Messages;
import com.microsoft.tfs.util.chunkingcodec.ChunkedEncoder;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;

public class StreamChunkedEncoder
implements ChunkedEncoder {
    private InputStream stream;
    private long bufferSize = -1L;
    private long bufferLen;
    private boolean complete = false;

    protected StreamChunkedEncoder() {
    }

    protected StreamChunkedEncoder(InputStream stream) {
        Check.notNull(stream, "stream");
        this.stream = stream;
    }

    protected StreamChunkedEncoder(InputStream stream, long bufferSize) {
        Check.notNull(stream, "stream");
        Check.isTrue(bufferSize >= 0L, "bufferSize >= 0");
        this.stream = stream;
        this.bufferSize = bufferSize;
    }

    protected void setBufferSize(long bufferSize) {
        Check.isTrue(bufferSize >= 0L, "bufferSize >= 0");
        this.bufferSize = bufferSize;
    }

    protected void setStream(InputStream stream) {
        Check.notNull(stream, "stream");
        this.stream = stream;
    }

    @Override
    public int encode(byte[] buf, int off, int len) throws IOException {
        if (this.bufferSize == 0L) {
            this.complete = true;
            return 0;
        }
        if (this.stream == null) {
            throw new IOException("Stream not initialized");
        }
        int chunklen = this.bufferSize >= 0L ? (int)Math.min(this.bufferSize - this.bufferLen, (long)len) : len;
        int readlen = this.stream.read(buf, off, chunklen);
        if (readlen < 0 && this.bufferSize < 0L) {
            this.complete = true;
            this.stream.close();
            return 0;
        }
        if (readlen < 0) {
            String messageFormat = Messages.getString("StreamChunkedEncoder.BufferUnderrunFormat");
            String message = MessageFormat.format(messageFormat, this.bufferSize, this.bufferLen);
            throw new IOException(message);
        }
        this.bufferLen += (long)readlen;
        if (this.bufferSize >= 0L && this.bufferSize == this.bufferLen) {
            this.complete = true;
            this.stream.close();
        }
        return readlen;
    }

    @Override
    public boolean isComplete() {
        return this.complete;
    }

    public void close() throws IOException {
        if (this.stream != null) {
            this.stream.close();
        }
    }
}

