/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.util.tasks;

import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.tasks.NullTaskMonitor;
import com.microsoft.tfs.util.tasks.TaskMonitor;
import java.util.LinkedList;

public class TaskMonitorService {
    private static final TaskMonitorThreadLocal taskMonitorStorage = new TaskMonitorThreadLocal();

    public static TaskMonitor getTaskMonitor() {
        TaskMonitor taskMonitor = taskMonitorStorage.getStack().peek();
        if (taskMonitor == null) {
            return NullTaskMonitor.INSTANCE;
        }
        return taskMonitor;
    }

    public static void pushTaskMonitor(TaskMonitor taskMonitor) {
        Check.notNull(taskMonitor, "taskMonitor");
        taskMonitorStorage.getStack().push(taskMonitor);
    }

    public static TaskMonitor popTaskMonitor() {
        return TaskMonitorService.popTaskMonitor(true);
    }

    public static TaskMonitor popTaskMonitor(boolean callDone) {
        TaskMonitor taskMonitor = taskMonitorStorage.getStack().pop();
        if (taskMonitor == null) {
            throw new IllegalStateException("there are no TaskMonitors on the stack");
        }
        if (callDone) {
            taskMonitor.done();
        }
        return taskMonitor;
    }

    private TaskMonitorService() {
    }

    private static class TaskMonitorStack {
        private final LinkedList stack = new LinkedList();

        private TaskMonitorStack() {
        }

        public void push(TaskMonitor taskMonitor) {
            this.stack.addFirst(taskMonitor);
        }

        public TaskMonitor pop() {
            if (this.stack.size() == 0) {
                return null;
            }
            TaskMonitor taskMonitor = (TaskMonitor)this.stack.removeFirst();
            return taskMonitor;
        }

        public TaskMonitor peek() {
            if (this.stack.size() == 0) {
                return null;
            }
            return (TaskMonitor)this.stack.getFirst();
        }
    }

    private static class TaskMonitorThreadLocal
    extends ThreadLocal {
        private TaskMonitorThreadLocal() {
        }

        protected Object initialValue() {
            return new TaskMonitorStack();
        }

        public TaskMonitorStack getStack() {
            return (TaskMonitorStack)this.get();
        }
    }
}

