/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.commons.links;

import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.assessment.ETrafficLightColor;
import org.conqat.lib.commons.net.UrlUtils;
import org.conqat.lib.commons.string.StringUtils;

public class TeamscaleLinkProvider {
    protected final String baseUrl;

    public TeamscaleLinkProvider(String baseUrl) {
        if (StringUtils.isEmpty((String)baseUrl)) {
            baseUrl = "https://no-teamscale-base-url-configured-in-teamscale-server-options.com";
        }
        this.baseUrl = StringUtils.ensureEndsWith((String)baseUrl, (String)"/");
    }

    public String createStaticFindingsBadgeUrl(int addedFindings, int inChangedCodeFindings, int removedFindings) {
        String badgeServiceUrl = "api/badges/findings/static";
        return this.baseUrl + badgeServiceUrl + "?added=" + addedFindings + "&changed=" + inChangedCodeFindings + "&removed=" + removedFindings;
    }

    public String createStaticSpecItemsBadgeUrl(int affectedSpecItems) {
        String badgeServiceUrl = "api/badges/spec-items/static";
        return this.baseUrl + badgeServiceUrl + "?affectedItems=" + affectedSpecItems;
    }

    public String createStaticTgaBadgeUrl(double ratio, int testedChurn, int untestedChange, int untestedAddition, @Nullable String incompleteBuildWarningText) {
        String badgeServiceUrl = "api/badges/test-gap/static";
        String staticTgaBadgeUrl = this.baseUrl + badgeServiceUrl + "?ratio=" + ratio + "&testedChurn=" + testedChurn + "&untestedChange=" + untestedChange + "&untestedAddition=" + untestedAddition + "&format=assessment";
        if (!StringUtils.isEmpty((String)incompleteBuildWarningText)) {
            staticTgaBadgeUrl = staticTgaBadgeUrl + "&incompleteBuildText=" + incompleteBuildWarningText;
        }
        return staticTgaBadgeUrl;
    }

    public String createStaticMetricBadgeUrl(String metricName, @Nullable ETrafficLightColor thresholdAssessment, String metricValue, @Nullable String incompleteBuildWarningText) {
        String badgeServiceUrl = "api/badges/metric/static";
        Object colorParameter = "";
        if (thresholdAssessment != null) {
            colorParameter = "&color=" + UrlUtils.encodeQueryParameter((String)thresholdAssessment.name());
        }
        String staticMetricThresholdBadgeUrl = this.baseUrl + badgeServiceUrl + "?metric=" + UrlUtils.encodeQueryParameter((String)metricName) + (String)colorParameter + "&value=" + UrlUtils.encodeQueryParameter((String)metricValue);
        if (!StringUtils.isEmpty((String)incompleteBuildWarningText)) {
            staticMetricThresholdBadgeUrl = staticMetricThresholdBadgeUrl + "&incompleteBuildText=" + UrlUtils.encodeQueryParameter((String)incompleteBuildWarningText);
        }
        return staticMetricThresholdBadgeUrl;
    }

    public String createStaticMetricGroupBadgeUrl(String groupName, boolean increasingValuesIndicateImprovement, int metricsWithoutData, int deterioratedMetrics, int stableMetrics, int improvedMetrics, int newThresholdViolations, @Nullable String incompleteBuildWarningText) {
        String badgeServiceUrl = "api/badges/metric-group/static";
        String staticMetricGroupBadgeUrl = this.baseUrl + badgeServiceUrl + "?metricGroupName=" + UrlUtils.encodeQueryParameter((String)groupName) + "&increasingValuesIndicateImprovement=" + increasingValuesIndicateImprovement + "&metricsWithoutData=" + metricsWithoutData + "&deterioratedMetrics=" + deterioratedMetrics + "&stableMetrics=" + stableMetrics + "&improvedMetrics=" + improvedMetrics + "&newThresholdViolations=" + newThresholdViolations;
        if (!StringUtils.isEmpty((String)incompleteBuildWarningText)) {
            staticMetricGroupBadgeUrl = staticMetricGroupBadgeUrl + "&incompleteBuildText=" + UrlUtils.encodeQueryParameter((String)incompleteBuildWarningText);
        }
        return staticMetricGroupBadgeUrl;
    }

    public String createStaticCriticalChangeBadgeUrl(String title, String text, String color, String tooltip) {
        String badgeServiceUrl = "api/badges/critical-change/static";
        String staticCriticalChangeBadgeUrl = this.baseUrl + badgeServiceUrl + "?title=" + UrlUtils.encodeQueryParameter((String)title) + "&text=" + UrlUtils.encodeQueryParameter((String)text) + "&color=" + UrlUtils.encodeQueryParameter((String)color);
        if (!StringUtils.isEmpty((String)tooltip)) {
            staticCriticalChangeBadgeUrl = staticCriticalChangeBadgeUrl + "&tooltip=" + UrlUtils.encodeQueryParameter((String)tooltip);
        }
        return staticCriticalChangeBadgeUrl;
    }

    public String createStaticCommitAlertsBadgeUrl(int commitAlerts) {
        String badgeServiceUrl = "api/badges/commit-alerts/static";
        return this.baseUrl + badgeServiceUrl + "?commitAlerts=" + commitAlerts;
    }

    public String createTeamscaleLogoLink() {
        return this.baseUrl + "images/teamscale-logo-gray-text-with-margin.svg";
    }

    public String createTeamscaleLogoLinkForBitbucketServer() {
        return this.baseUrl + "images/teamscale-logo-gray-text-bitbucket.png";
    }

    public String createTeamscaleNotificationLogoLink() {
        return this.baseUrl + "images/notification-logo.png";
    }
}

