/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.commons.links;

import com.teamscale.commons.links.TeamscaleLinkProvider;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.index.shared.MergeRequestIdentifier;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.lib.commons.net.UrlUtils;

public class TeamscaleProjectLinkProvider
extends TeamscaleLinkProvider {
    protected final PublicProjectId projectId;

    public TeamscaleProjectLinkProvider(String baseUrl, PublicProjectId projectId) {
        super(baseUrl);
        this.projectId = projectId;
    }

    public String createMergeRequestDetailsLink(MergeRequestIdentifier mergeRequestId) {
        return this.baseUrl + "activity/merge-requests/" + UrlUtils.encodePathSegment((String)this.projectId.toString()) + "/" + UrlUtils.encodePathSegment((String)mergeRequestId.toString());
    }

    public String createTaskDetailLink(int taskId) {
        return this.baseUrl + "qualitycontrol/tasks/" + UrlUtils.encodePathSegment((String)this.projectId.toString()) + "/?id=" + taskId;
    }

    public String createIssuePerspectiveLink(String issueId, @Nullable String branch, boolean hideResolvedFindingsInLink) {
        String link = this.baseUrl + "activity/issues/" + UrlUtils.encodePathSegment((String)this.projectId.toString()) + "/?action=view&id=" + UrlUtils.encodeQueryParameter((String)issueId);
        if (hideResolvedFindingsInLink) {
            link = link + "&hideResolvedFindings=true";
        }
        if (branch != null) {
            link = link + "&issueBranch=" + UrlUtils.encodeQueryParameter((String)branch);
        }
        return link;
    }
}

