/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.commons.service.client;

import java.time.Duration;

public class ServerDetails {
    private static final int DEFAULT_TIMEOUT_SECONDS = 10;
    private final String url;
    private final String username;
    private final String password;
    private final int timeoutSeconds;

    public ServerDetails(String url, String username, String password) {
        this(url, username, password, 10);
    }

    public ServerDetails(String url, String username, String password, int timeoutSeconds) {
        this.url = url;
        this.username = username;
        this.password = password;
        this.timeoutSeconds = timeoutSeconds;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public int hashCode() {
        return this.url.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ServerDetails)) {
            return false;
        }
        return this.url.equals(((ServerDetails)obj).url);
    }

    public String toString() {
        return this.username + "@" + this.url;
    }

    public int getTimeoutSeconds() {
        return this.timeoutSeconds;
    }

    public ServerDetails withTimeOut(int timeOutSeconds) {
        return new ServerDetails(this.url, this.username, this.password, timeOutSeconds);
    }

    public ServerDetails withTimeOut(Duration timeOut) {
        return new ServerDetails(this.url, this.username, this.password, Math.toIntExact(timeOut.getSeconds()));
    }
}

