/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.commons.findings;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.commons.findings.StatementPathElement;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.ManualTestCaseTextRegionLocation;
import org.conqat.engine.commons.findings.location.QualifiedNameLocation;
import org.conqat.engine.commons.findings.location.TeamscaleIssueFieldLocation;
import org.conqat.engine.commons.findings.location.TeamscaleIssueLocation;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.assessment.ETrafficLightColor;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass(containedInBackup=true)
public class DetachedFinding
implements Serializable {
    private static final Logger LOGGER = LogManager.getLogger(DetachedFinding.class);
    private static final long serialVersionUID = 1L;
    public static final int MAX_MESSAGE_LENGTH = 1000;
    protected static final String LOCATION_PROPERTY = "location";
    protected static final String GROUP_NAME_PROPERTY = "groupName";
    protected static final String CATEGORY_NAME_PROPERTY = "categoryName";
    protected static final String MESSAGE_PROPERTY = "message";
    private static final String ASSESSMENT_PROPERTY = "assessment";
    @JsonProperty(value="location")
    @Schema(implementation=ElementLocationSubtype.class)
    private ElementLocation location;
    @JsonProperty(value="groupName")
    private String groupName;
    @JsonProperty(value="categoryName")
    private String categoryName;
    @JsonProperty(value="message")
    private String message;
    @JsonProperty(value="assessment")
    private @Nullable ETrafficLightColor assessment;
    @JsonProperty(value="siblingLocations")
    @Schema(implementation=ElementLocations.class)
    private @Nullable List<ElementLocation> siblingLocations;
    private transient Set<String> siblingLocationCache = null;
    @JsonProperty(value="secondaryLocations")
    @Schema(implementation=ElementLocations.class)
    private @Nullable List<ElementLocation> secondaryLocations;
    @JsonProperty(value="properties")
    @Schema(additionalProperties=Schema.AdditionalPropertiesValue.USE_ADDITIONAL_PROPERTIES_ANNOTATION, oneOf={String.class, Number.class})
    private final Map<String, Object> properties = new HashMap<String, Object>();
    @JsonProperty(value="statementPath")
    private @Nullable List<StatementPathElement> statementPath = null;
    @JsonProperty(value="guidelineMapping")
    private @Nullable SetMap<String, String> guidelineMapping = null;

    public DetachedFinding(String groupName, String categoryName, String message, ElementLocation location) {
        this(groupName, categoryName, message, location, null);
    }

    public DetachedFinding(String groupName, String categoryName, String message, ElementLocation location, ETrafficLightColor assessment, Map<String, Object> findingProperties) {
        this(groupName, categoryName, message, location, assessment);
        this.properties.putAll(findingProperties);
    }

    @JsonCreator
    public DetachedFinding(@JsonProperty(value="groupName") String groupName, @JsonProperty(value="categoryName") String categoryName, @JsonProperty(value="message") String message, @JsonProperty(value="location") ElementLocation location, @JsonProperty(value="assessment") ETrafficLightColor assessment) {
        CCSMAssert.isNotNull((Object)location);
        this.groupName = groupName;
        this.categoryName = categoryName;
        this.location = location;
        this.assessment = assessment;
        this.setMessage(message);
    }

    public DetachedFinding(DetachedFinding other) {
        this(other.groupName, other.categoryName, other.message, other.location, other.assessment);
        if (other.hasSiblings()) {
            this.siblingLocations = new ArrayList<ElementLocation>(other.siblingLocations);
        }
        if (other.secondaryLocations != null) {
            this.secondaryLocations = new ArrayList<ElementLocation>(other.secondaryLocations);
        }
        this.properties.putAll(other.properties);
        this.statementPath = other.statementPath;
        this.guidelineMapping = other.guidelineMapping;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public String getCategoryName() {
        return this.categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }

    public ElementLocation getLocation() {
        return this.location;
    }

    public void setLocation(ElementLocation location) {
        CCSMAssert.isNotNull((Object)location);
        this.location = location;
    }

    public String getLocationPathString() {
        return this.location.toString();
    }

    public String getLocationString() {
        return this.location.toLocationString();
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        if (message.length() > 1000) {
            this.message = StringUtils.truncateWithEllipsis((String)message, (int)1000);
            Supplier[] supplierArray = new Supplier[2];
            supplierArray[0] = message::length;
            supplierArray[1] = this::toString;
            LOGGER.error("Shortening overly long finding message of length {} for finding {}", supplierArray);
            return;
        }
        this.message = message;
    }

    public boolean hasSiblings() {
        return this.siblingLocations != null && !this.siblingLocations.isEmpty();
    }

    public List<ElementLocation> getSiblingLocations() {
        if (this.siblingLocations == null) {
            return CollectionUtils.emptyList();
        }
        return CollectionUtils.asUnmodifiable(this.siblingLocations);
    }

    public void removeMatchingSiblingLocations(Predicate<? super ElementLocation> filter) {
        this.siblingLocations.removeIf(filter);
    }

    public List<ElementLocation> getSecondaryLocations() {
        if (this.secondaryLocations == null) {
            return CollectionUtils.emptyList();
        }
        return CollectionUtils.asUnmodifiable(this.secondaryLocations);
    }

    public void addSiblingLocation(ElementLocation location) {
        String locationString;
        if (this.siblingLocations == null) {
            this.siblingLocations = new ArrayList<ElementLocation>();
        }
        if (this.siblingLocationCache == null) {
            this.siblingLocationCache = new HashSet<String>(CollectionUtils.map(this.siblingLocations, ElementLocation::getLocationKey));
            this.siblingLocationCache.add(this.location.getLocationKey());
        }
        if (!this.siblingLocationCache.contains(locationString = location.getLocationKey())) {
            this.siblingLocations.add(location);
            this.siblingLocationCache.add(locationString);
        }
    }

    public void addSiblingFindings(Collection<DetachedFinding> findings) {
        findings.forEach(this::addSiblingFinding);
    }

    public void addSiblingLocations(Collection<? extends ElementLocation> siblingLocations) {
        siblingLocations.forEach(this::addSiblingLocation);
    }

    public void addSiblingFinding(DetachedFinding sibling) {
        this.addSiblingLocation(sibling.getLocation());
    }

    public void addSecondaryLocation(ElementLocation location) {
        if (this.secondaryLocations == null) {
            this.secondaryLocations = new ArrayList<ElementLocation>();
        }
        this.secondaryLocations.add(location);
    }

    public void addSecondaryLocations(Collection<ElementLocation> locations) {
        if (this.secondaryLocations == null) {
            this.secondaryLocations = new ArrayList<ElementLocation>();
        }
        this.secondaryLocations.addAll(locations);
    }

    public Map<String, Object> getProperties() {
        return CollectionUtils.asUnmodifiable(this.properties);
    }

    public void setProperty(String name, Object value) {
        this.properties.put(name, value);
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties.clear();
        this.addProperties(properties);
    }

    public void addProperties(Map<String, Object> properties) {
        this.properties.putAll(properties);
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    public @Nullable ETrafficLightColor getAssessment() {
        return this.assessment;
    }

    public void setAssessment(ETrafficLightColor assessment) {
        this.assessment = assessment;
    }

    public String toString() {
        return this.getMessage() + " (" + this.getGroupName() + ") @ " + this.location.toLocationString();
    }

    public List<StatementPathElement> getStatementPath() {
        if (this.statementPath == null) {
            return CollectionUtils.emptyList();
        }
        return this.statementPath;
    }

    public void setStatementPath(List<StatementPathElement> path) {
        this.statementPath = path;
    }

    public void setGuidelineMapping(SetMap<String, String> guidelineMapping) {
        this.guidelineMapping = guidelineMapping;
    }

    public SetMap<String, String> getGuidelineMapping() {
        if (this.guidelineMapping == null) {
            return new SetMap();
        }
        return this.guidelineMapping;
    }

    @ArraySchema(schema=@Schema(implementation=ElementLocationSubtype.class))
    private static interface ElementLocations
    extends List<ElementLocation> {
    }

    @Schema(oneOf={ElementLocation.class, TextRegionLocation.class, QualifiedNameLocation.class, TeamscaleIssueLocation.class, ManualTestCaseTextRegionLocation.class, TeamscaleIssueFieldLocation.class})
    private static interface ElementLocationSubtype {
    }
}

