/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.commons.util;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.StreamReadConstraints;
import com.fasterxml.jackson.core.StreamReadFeature;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.cfg.MapperBuilder;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Optional;
import org.conqat.engine.commons.util.CollectionMapSerializationModule;
import org.conqat.engine.commons.util.ColorSerializationModule;
import org.conqat.engine.commons.util.CompactLinesSerializationModule;
import org.conqat.engine.commons.util.JavaPathModule;
import org.conqat.engine.commons.util.JsonSerializationException;
import org.conqat.engine.commons.util.NullableFieldValidator;
import org.conqat.engine.commons.util.SerializationViews;
import org.conqat.engine.commons.util.TypeReferenceChecker;
import org.conqat.engine.commons.util.UnmodifiableCollectionsModule;
import org.conqat.engine.commons.util.canonical.CanonicalJsonModule;
import org.conqat.lib.commons.function.FunctionWithException;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;
import org.intellij.lang.annotations.Language;

public final class JsonUtils {
    private static final ObjectMapper OBJECT_MAPPER = JsonUtils.defaultObjectMapperBuilder().build();
    private static final ObjectMapper CANONICAL_OBJECT_MAPPER = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonUtils.defaultObjectMapperBuilder().enable(new MapperFeature[]{MapperFeature.SORT_PROPERTIES_ALPHABETICALLY})).disable(new MapperFeature[]{MapperFeature.SORT_CREATOR_PROPERTIES_FIRST})).enable(new SerializationFeature[]{SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS})).addModule((Module)new CanonicalJsonModule())).build();

    public static JsonMapper.Builder defaultObjectMapperBuilder() {
        StreamReadConstraints streamReadConstraints = StreamReadConstraints.builder().maxStringLength(Integer.MAX_VALUE).build();
        JsonFactory jsonFactory = JsonFactory.builder().enable(JsonReadFeature.ALLOW_TRAILING_COMMA).enable(JsonReadFeature.ALLOW_UNQUOTED_FIELD_NAMES).enable(JsonReadFeature.ALLOW_SINGLE_QUOTES).enable(JsonReadFeature.ALLOW_JAVA_COMMENTS).enable(StreamReadFeature.INCLUDE_SOURCE_IN_LOCATION).streamReadConstraints(streamReadConstraints).build();
        JsonMapper.Builder builder = JsonMapper.builder((JsonFactory)jsonFactory);
        return JsonUtils.configureDefaultSettings(builder);
    }

    public static <M extends ObjectMapper, B extends MapperBuilder<M, B>> B configureDefaultSettings(B builder) {
        return (B)builder.addModule((Module)new ColorSerializationModule()).addModule((Module)new CompactLinesSerializationModule()).addModule((Module)new UnmodifiableCollectionsModule()).addModule((Module)new CollectionMapSerializationModule()).addModule((Module)new GuavaModule()).addModule((Module)new JavaTimeModule()).addModule((Module)new JavaPathModule()).addModule((Module)new Jdk8Module()).addMixIn(Rectangle2D.class, Rectangle2DJsonIgnore.class).visibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.NONE).visibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY).serializationInclusion(JsonInclude.Include.NON_NULL).disable(new DeserializationFeature[]{DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES}).enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS});
    }

    public static String serializeToJSON(Object object) {
        try {
            return JsonUtils.getDefaultWriter(OBJECT_MAPPER).writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new JsonSerializationRuntimeException(e);
        }
    }

    public static String serializeToJSONPrettyPrint(Object object) {
        try {
            return JsonUtils.getDefaultWriter(OBJECT_MAPPER).withDefaultPrettyPrinter().writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new JsonSerializationRuntimeException(e);
        }
    }

    public static ObjectMapper getObjectMapper() {
        return OBJECT_MAPPER;
    }

    private static <T> JavaType getJavaType(Class<T> resultClass) {
        return OBJECT_MAPPER.constructType(resultClass);
    }

    public static <T> JavaType getJavaListType(Class<T> resultClass) {
        return OBJECT_MAPPER.getTypeFactory().constructCollectionType(List.class, resultClass);
    }

    public static <T> JavaType getNestedJavaListType(Class<T> resultClass) {
        return OBJECT_MAPPER.getTypeFactory().constructCollectionType(List.class, (JavaType)OBJECT_MAPPER.getTypeFactory().constructCollectionType(List.class, resultClass));
    }

    public static <T> T deserializeFromJson(@Language(value="JSON") String json, Class<T> expectedClass) throws JsonSerializationException {
        return JsonUtils.deserializeFromJson((Reader)new StringReader(json), expectedClass);
    }

    public static <T> T deserializeFromJson(Reader jsonReader, Class<T> expectedClass) throws JsonSerializationException {
        return JsonUtils.deserializeFromJson(jsonReader, JsonUtils.getJavaType(expectedClass));
    }

    public static <T> T deserializeFromJson(TreeNode jsonNode, Class<T> expectedClass) throws JsonSerializationException {
        return JsonUtils.deserializeFromJson(jsonNode, JsonUtils.getJavaType(expectedClass));
    }

    public static <T> T deserializeFromJson(@Language(value="JSON") String json, TypeReference<T> expectedType) throws JsonSerializationException {
        return JsonUtils.deserializeFromJson((Reader)new StringReader(json), expectedType);
    }

    public static <T> T deserializeFromJson(Reader jsonReader, TypeReference<T> expectedType) throws JsonSerializationException {
        return JsonUtils.deserializeFromJson(jsonReader, JsonUtils.constructType(expectedType));
    }

    public static <T> T deserializeFromJson(TreeNode jsonNode, TypeReference<T> expectedType) throws JsonSerializationException {
        return JsonUtils.deserializeFromJson(jsonNode, JsonUtils.constructType(expectedType));
    }

    private static <T> JavaType constructType(TypeReference<T> expectedType) {
        TypeReferenceChecker.checkFullyResolved(expectedType);
        return OBJECT_MAPPER.getTypeFactory().constructType(expectedType);
    }

    public static <T> T deserializeFromJson(@Language(value="JSON") String json, JavaType expectedType) throws JsonSerializationException {
        return JsonUtils.deserializeFromJson((Reader)new StringReader(json), expectedType);
    }

    public static <T> T deserializeFromJson(Reader jsonReader, JavaType expectedType) throws JsonSerializationException {
        return JsonUtils.safeConvert(objectMapper -> objectMapper.readValue(jsonReader, expectedType));
    }

    public static <T> T deserializeFromJson(TreeNode jsonNode, JavaType expectedType) throws JsonSerializationException {
        return JsonUtils.safeConvert(objectMapper -> objectMapper.treeToValue(jsonNode, expectedType));
    }

    public static JsonNode deserializeFromJson(@Language(value="JSON") String json) throws JsonSerializationException {
        return (JsonNode)JsonUtils.safeConvert(objectMapper -> objectMapper.readTree(json));
    }

    public static <T> T deserializeFromJsonWithNullCheck(@Language(value="JSON") String json, Class<T> expectedClass) throws JsonSerializationException {
        T parsedObject = JsonUtils.deserializeFromJson(json, expectedClass);
        return NullableFieldValidator.ensureAllFieldsNonNull(parsedObject, json);
    }

    public static Optional<JsonNode> getWithCapitalizedOrLowercaseKey(JsonNode jsonNode, String key) {
        if (jsonNode.has(key = key.toLowerCase())) {
            return Optional.of(jsonNode.get(key));
        }
        return Optional.ofNullable(jsonNode.get(StringUtils.capitalize((String)key)));
    }

    public static boolean isValidJson(@Language(value="JSON") String json) {
        try {
            OBJECT_MAPPER.readTree(json);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static String prettyPrintJSON(@Language(value="JSON") String json) throws JsonSerializationException {
        return (String)JsonUtils.safeConvert(objectMapper -> {
            JsonNode jsonInstance = objectMapper.readTree(json);
            return JsonUtils.getDefaultWriter(objectMapper).withDefaultPrettyPrinter().writeValueAsString((Object)jsonInstance);
        });
    }

    public static String serializeToJSONPrettyPrinted(Object object) throws JsonSerializationException {
        return (String)JsonUtils.safeConvert(objectMapper -> JsonUtils.getDefaultWriter(objectMapper).withDefaultPrettyPrinter().writeValueAsString(object));
    }

    public static String serializeToJSONCanonical(Object object) throws JsonSerializationException {
        return (String)JsonUtils.safeConvert(objectMapper -> JsonUtils.getDefaultWriter(objectMapper).withDefaultPrettyPrinter().writeValueAsString(object), CANONICAL_OBJECT_MAPPER);
    }

    private static <T> T safeConvert(FunctionWithException<ObjectMapper, T, IOException> convertAction) throws JsonSerializationException {
        return JsonUtils.safeConvert(convertAction, OBJECT_MAPPER);
    }

    private static <T> T safeConvert(FunctionWithException<ObjectMapper, T, IOException> convertAction, ObjectMapper objectMapper) throws JsonSerializationException {
        try {
            return (T)convertAction.apply((Object)objectMapper);
        }
        catch (JsonProcessingException e) {
            throw new JsonSerializationException("Input was invalid JSON.", e);
        }
        catch (Throwable t) {
            throw new JsonSerializationException("Trouble during JSON processing: " + t.getMessage(), t);
        }
    }

    public static boolean isNotSerialized(Field field) {
        int fieldModifiers = field.getModifiers();
        if (Modifier.isStatic(fieldModifiers) || Modifier.isTransient(fieldModifiers)) {
            return true;
        }
        if (field.isAnnotationPresent(JsonIgnore.class)) {
            return true;
        }
        return field.getName().contains("$");
    }

    private static ObjectWriter getDefaultWriter(ObjectMapper objectMapper) {
        return objectMapper.writerWithView(SerializationViews.DefaultView.class);
    }

    @SafeVarargs
    public static String serializeIgnoringCustomSerializationByAnnotations(Object obj, Class<? extends Annotation> ... annotationClasses) throws JsonProcessingException {
        ObjectMapper objectMapper = JsonUtils.defaultObjectMapperBuilder().build();
        objectMapper.setAnnotationIntrospector((AnnotationIntrospector)new IgnoreSpecificSerializerIntrospector(annotationClasses));
        return objectMapper.writeValueAsString(obj);
    }

    private JsonUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }

    public static interface Rectangle2DJsonIgnore {
        @JsonIgnore
        public String getBounds2D();
    }

    public static class JsonSerializationRuntimeException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public JsonSerializationRuntimeException(Throwable cause) {
            super(cause);
        }
    }

    private static class IgnoreSpecificSerializerIntrospector
    extends JacksonAnnotationIntrospector {
        private static final long serialVersionUID = 1L;
        private final Class<? extends Annotation>[] ignoreAnnotations;

        @SafeVarargs
        private IgnoreSpecificSerializerIntrospector(Class<? extends Annotation> ... ignoreAnnotations) {
            this.ignoreAnnotations = ignoreAnnotations;
        }

        public Object findSerializer(Annotated a) {
            if (a.hasOneOf((Class[])this.ignoreAnnotations)) {
                return null;
            }
            return super.findSerializer(a);
        }
    }
}

