/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.commons.util.canonical;

import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.fasterxml.jackson.databind.ser.std.StdDelegatingSerializer;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.Converter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.commons.util.canonical.CanonicalJson;

class OrderingBeanSerializerModifier
extends BeanSerializerModifier {
    private static final long serialVersionUID = 1L;

    OrderingBeanSerializerModifier() {
    }

    public List<BeanPropertyWriter> changeProperties(SerializationConfig config, BeanDescription beanDesc, List<BeanPropertyWriter> beanProperties) {
        for (BeanPropertyWriter beanProperty : beanProperties) {
            CanonicalJson canonicalJson = (CanonicalJson)beanProperty.getAnnotation(CanonicalJson.class);
            if (canonicalJson == null) continue;
            OrderingBeanSerializerModifier.applyCanonicalJson(config, beanProperty, canonicalJson);
        }
        return beanProperties;
    }

    private static <T> void applyCanonicalJson(SerializationConfig config, BeanPropertyWriter beanProperty, CanonicalJson canonicalJson) {
        if (!Collection.class.isAssignableFrom(beanProperty.getType().getRawClass())) {
            throw new IllegalArgumentException(String.format("Type %s is not supported for ordered serialization", beanProperty.getType().getRawClass()));
        }
        Comparator<T> comparator = OrderingBeanSerializerModifier.buildComparator(config, beanProperty, canonicalJson.ordering());
        StdDelegatingSerializer serializer = new StdDelegatingSerializer(new SortedCollectionConverter<T>(comparator, beanProperty.getType()));
        beanProperty.assignSerializer((JsonSerializer)serializer);
    }

    private static <T> Comparator<T> buildComparator(SerializationConfig config, BeanPropertyWriter beanProperty, CanonicalJson.OrderBy orderBy) {
        boolean hasProperties;
        boolean hasComparator = orderBy.comparator() != CanonicalJson.OrderBy.NoComparator.class;
        boolean bl = hasProperties = orderBy.properties().length > 0;
        if (hasComparator && hasProperties) {
            throw new IllegalArgumentException(String.format("%s annotation on %s has properties (%s) and a comparator (%s) defined, but only one can be present", CanonicalJson.OrderBy.class.getSimpleName(), beanProperty.getMember(), Arrays.toString(orderBy.properties()), orderBy.comparator()));
        }
        if (!hasComparator && !hasProperties) {
            throw new IllegalArgumentException(String.format("%s annotation on %s has neither properties nor a comparator defined", CanonicalJson.OrderBy.class.getSimpleName(), beanProperty.getMember()));
        }
        if (hasComparator) {
            return OrderingBeanSerializerModifier.instantiateComparatorByClass(config, orderBy.comparator());
        }
        return OrderingBeanSerializerModifier.instantiateComparatorByProperties(config, beanProperty.getType().getContentType(), orderBy.properties());
    }

    private static <T> Comparator<T> instantiateComparatorByProperties(SerializationConfig config, JavaType contentType, String[] properties) {
        Comparator<Object> result = EmptyComparator.getInstance();
        Map propertiesByName = config.introspect(contentType).findProperties().stream().collect(Collectors.toMap(BeanPropertyDefinition::getName, Function.identity()));
        for (String propertyName : properties) {
            BeanPropertyDefinition propertyDefinition = (BeanPropertyDefinition)propertiesByName.get(propertyName);
            if (propertyDefinition == null) {
                throw new IllegalArgumentException(String.format("Property \"%s\" was not found on %s", propertyName, contentType.getRawClass()));
            }
            if (!Comparable.class.isAssignableFrom(propertyDefinition.getRawPrimaryType()) && !propertyDefinition.getRawPrimaryType().isPrimitive()) {
                throw new IllegalArgumentException(String.format("Property \"%s\" is not of type Comparable (detected type: %s)", propertyName, propertyDefinition.getRawPrimaryType()));
            }
            AnnotatedMember accessor = propertyDefinition.getAccessor();
            if (config.isEnabled(MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS)) {
                accessor.fixAccess(config.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS));
            }
            result = result.thenComparing(arg_0 -> ((AnnotatedMember)accessor).getValue(arg_0), Comparator.nullsFirst(Comparator.naturalOrder()));
        }
        return result;
    }

    private static <T> @NonNull Comparator<T> instantiateComparatorByClass(SerializationConfig config, Class<? extends Comparator> comparatorClass) {
        try {
            Constructor<? extends Comparator> constructor = comparatorClass.getDeclaredConstructor(new Class[0]);
            if (Modifier.isPrivate(constructor.getModifiers())) {
                throw new IllegalArgumentException(String.format("Comparator %s only has a private no-args constructor and cannot be instantiated", comparatorClass));
            }
            if (config.isEnabled(MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS)) {
                ClassUtil.checkAndFixAccess(constructor, (boolean)config.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS));
            }
            return constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new IllegalArgumentException(String.format("Unable to instantiate %s", comparatorClass), e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(String.format("Comparator %s has no invocable no-args constructor", comparatorClass), e);
        }
    }

    private static class SortedCollectionConverter<T>
    implements Converter<Collection<T>, SortedCollection<T>> {
        private final Comparator<T> comparator;
        private final JavaType inputType;

        private SortedCollectionConverter(Comparator<T> comparator, JavaType inputType) {
            this.inputType = inputType;
            this.comparator = comparator;
        }

        public JavaType getInputType(TypeFactory typeFactory) {
            return this.inputType;
        }

        public JavaType getOutputType(TypeFactory typeFactory) {
            return typeFactory.constructCollectionLikeType(SortedCollection.class, this.inputType.getContentType());
        }

        public SortedCollection<T> convert(Collection<T> value) {
            return new SortedCollection<T>(value, this.comparator);
        }
    }

    private static class EmptyComparator<T>
    implements Comparator<T> {
        private static final EmptyComparator INSTANCE = new EmptyComparator();

        private EmptyComparator() {
        }

        public static <T> EmptyComparator<T> getInstance() {
            return INSTANCE;
        }

        @Override
        public Comparator<T> reversed() {
            return this;
        }

        @Override
        public Comparator<T> thenComparing(Comparator<? super T> other) {
            return other;
        }

        @Override
        public int compare(T o1, T o2) {
            return 0;
        }
    }

    private static class SortedCollection<T> {
        private final Collection<T> source;
        private final Comparator<T> comparator;

        public SortedCollection(Collection<T> source, Comparator<T> comparator) {
            this.source = source;
            this.comparator = comparator;
        }

        @JsonValue
        public List<T> toJson() {
            return this.source.stream().sorted(this.comparator).collect(Collectors.toList());
        }
    }
}

