/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.index.shared;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Function;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableMap;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;

public class PreCommitUploadData
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="uniformPathToContentMap")
    private final HashMap<String, String> uniformPathToContentMap = new HashMap();
    @JsonProperty(value="deletedUniformPaths")
    private final HashSet<String> deletedUniformPaths = new HashSet();

    @JsonCreator
    public PreCommitUploadData() {
    }

    public static PreCommitUploadData from(Map<String, String> uniformPathToContentMap, Collection<String> deletedUniformPaths) {
        return new PreCommitUploadData(CollectionUtils.map(uniformPathToContentMap, UniformPathCompatibilityUtil::convert, Function.identity()), CollectionUtils.map(deletedUniformPaths, UniformPathCompatibilityUtil::convert));
    }

    public PreCommitUploadData(Map<UniformPath, String> uniformPathToContentMap, Collection<UniformPath> deletedUniformPaths) {
        for (Map.Entry<UniformPath, String> entry : uniformPathToContentMap.entrySet()) {
            UniformPath uniformPath = entry.getKey();
            String content = entry.getValue();
            this.uniformPathToContentMap.put(uniformPath.toString(), content);
        }
        for (UniformPath uniformPath : deletedUniformPaths) {
            this.deletedUniformPaths.add(uniformPath.toString());
        }
    }

    public UnmodifiableMap<String, String> getUniformPathToContentMap() {
        return CollectionUtils.asUnmodifiable(this.uniformPathToContentMap);
    }

    public UnmodifiableSet<String> getDeletedUniformPaths() {
        return CollectionUtils.asUnmodifiable(this.deletedUniformPaths);
    }

    public boolean isValid() {
        return this.deletedUniformPaths != null && this.uniformPathToContentMap != null;
    }

    public boolean isEmpty() {
        return this.deletedUniformPaths.isEmpty() && this.uniformPathToContentMap.isEmpty();
    }

    public boolean isDeletionOnlyUpload() {
        return !this.deletedUniformPaths.isEmpty() && this.uniformPathToContentMap.isEmpty();
    }
}

