/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.index.shared.tests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.hash.Hashing;
import com.teamscale.commons.utils.StringPool;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.index.shared.tests.ETestExecutionResult;
import org.conqat.engine.sourcecode.coverage.TestUniformPathUtils;
import org.conqat.lib.commons.assessment.Assessment;
import org.conqat.lib.commons.assessment.ETrafficLightColor;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;
import org.conqat.lib.commons.uniformpath.RelativeUniformPath;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;

@IndexValueClass(containedInBackup=true)
public class TestExecution
implements Serializable {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final long serialVersionUID = 1L;
    private static final String UNIFORM_PATH_PROPERTY = "uniformPath";
    private static final String TEST_LOCATIONS_PROPERTY = "testLocations";
    private static final String DURATION_SECONDS_PROPERTY = "durationSeconds";
    private static final String RESULT_PROPERTY = "result";
    private static final String MESSAGE_PROPERTY = "message";
    protected static final String HASH_PROPERTY = "hash";
    private static final String EXTERNAL_LINK_PROPERTY = "externalLink";
    private static final String EXECUTION_UNIT_PROPERTY = "executionUnit";
    private static final String ASSOCIATED_SPEC_ITEMS_PROPERTY = "associatedSpecItems";
    public static final int MAX_TEST_NAME_LENGTH = 400;
    public static final int MAX_TEST_NAME_LENGTH_WITHOUT_HASH = 347;
    @JsonProperty(value="uniformPath")
    private final String uniformPath;
    @JsonProperty(value="testLocations")
    private @Nullable List<String> testLocations;
    @JsonProperty(value="durationSeconds")
    private final double durationSeconds;
    @JsonProperty(value="result")
    private final ETestExecutionResult result;
    @JsonProperty(value="externalLink")
    private final @Nullable String externalLink;
    @JsonProperty(value="message")
    private final @Nullable String message;
    @JsonProperty(value="hash")
    protected final @Nullable String hash;
    @JsonProperty(value="executionUnit")
    private final @Nullable String executionUnit;
    @JsonProperty(value="associatedSpecItems")
    private final @Nullable List<String> associatedSpecItems;

    private TestExecution(UniformPath uniformPath, @Nullable List<String> testLocations, double durationSeconds, ETestExecutionResult result, @Nullable String message, @Nullable String hash, @Nullable String externalLink, @Nullable String executionUnit, @Nullable List<String> associatedSpecItems) {
        this(uniformPath.toString(), testLocations, durationSeconds, result, message, hash, externalLink, executionUnit, associatedSpecItems);
    }

    @JsonCreator
    public TestExecution(@JsonProperty(value="uniformPath") String uniformPath, @JsonProperty(value="testLocations") @Nullable List<String> testLocations, @JsonProperty(value="durationSeconds") double durationSeconds, @JsonProperty(value="result") ETestExecutionResult result, @JsonProperty(value="message") @Nullable String message, @JsonProperty(value="hash") @Nullable String hash, @JsonProperty(value="externalLink") @Nullable String externalLink, @JsonProperty(value="executionUnit") @Nullable String executionUnit, @JsonProperty(value="associatedSpecItems") @Nullable List<String> associatedSpecItems) {
        TestUniformPathUtils.assertIsTestExecutionPath(uniformPath);
        Preconditions.checkArgument((result != null ? 1 : 0) != 0, (Object)"Result can't be null for test execution");
        Preconditions.checkArgument((durationSeconds >= 0.0 ? 1 : 0) != 0, (Object)"Test duration can't be negative");
        this.uniformPath = StringPool.intern(uniformPath);
        this.testLocations = testLocations;
        this.durationSeconds = durationSeconds;
        this.result = result;
        this.message = message;
        this.hash = hash;
        this.externalLink = externalLink;
        this.executionUnit = executionUnit;
        this.associatedSpecItems = associatedSpecItems;
    }

    public String getUniformPath() {
        return this.uniformPath;
    }

    public UniformPath toUniformPath() {
        return UniformPathCompatibilityUtil.convert(this.uniformPath);
    }

    public @Nullable List<String> getTestLocations() {
        return this.testLocations;
    }

    public double getDurationMillis() {
        return this.durationSeconds * 1000.0;
    }

    public double getDurationSeconds() {
        return this.durationSeconds;
    }

    public ETestExecutionResult getResult() {
        return this.result;
    }

    public @Nullable String getExternalLink() {
        return this.externalLink;
    }

    public Optional<String> getMessage() {
        return Optional.ofNullable(this.message);
    }

    public @Nullable String getExecutionUnit() {
        return this.executionUnit;
    }

    public @Nullable List<String> getAssociatedSpecItems() {
        return this.associatedSpecItems;
    }

    public @Nullable String getHash() {
        return this.hash;
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this);
    }

    public boolean isFailure() {
        return this.result == ETestExecutionResult.ERROR || this.result == ETestExecutionResult.FAILURE;
    }

    public Assessment createAssessment() {
        return new Assessment(switch (this.result) {
            default -> throw new MatchException(null, null);
            case ETestExecutionResult.PASSED -> ETrafficLightColor.GREEN;
            case ETestExecutionResult.IGNORED, ETestExecutionResult.SKIPPED, ETestExecutionResult.INCONCLUSIVE -> ETrafficLightColor.YELLOW;
            case ETestExecutionResult.ERROR, ETestExecutionResult.FAILURE -> ETrafficLightColor.RED;
        });
    }

    public static TestExecution merge(Collection<TestExecution> testExecutions) {
        Preconditions.checkArgument((!testExecutions.isEmpty() ? 1 : 0) != 0, (Object)"Can't merge empty collection of test executions.");
        if (testExecutions.size() == 1) {
            return (TestExecution)Iterables.getOnlyElement(testExecutions);
        }
        Iterator<TestExecution> it = testExecutions.iterator();
        TestExecution worstExecution = it.next();
        HashSet<String> associatedSpecItems = new HashSet<String>();
        while (it.hasNext()) {
            TestExecution nextExecution = it.next();
            Preconditions.checkArgument((boolean)nextExecution.uniformPath.equals(worstExecution.uniformPath), (Object)"Can't merge test executions from separate uniform paths.");
            if (ETestExecutionResult.worst(nextExecution.result, worstExecution.result) != worstExecution.result) {
                worstExecution = nextExecution;
            }
            if (nextExecution.associatedSpecItems == null) continue;
            associatedSpecItems.addAll(nextExecution.associatedSpecItems);
        }
        double maxDurationSeconds = testExecutions.stream().mapToDouble(TestExecution::getDurationSeconds).max().getAsDouble();
        return new TestExecution(worstExecution.uniformPath, worstExecution.getTestLocations(), maxDurationSeconds, worstExecution.result, worstExecution.message, worstExecution.hash, worstExecution.externalLink, worstExecution.getExecutionUnit(), new ArrayList<String>(associatedSpecItems));
    }

    public static TestExecution pickFromFlickering(TestExecution testExecution1, TestExecution testExecution2) {
        ETestExecutionResult worstResult;
        if (!testExecution1.uniformPath.equals(testExecution2.uniformPath)) {
            LOGGER.error("Expected both execution to have the same uniform path, but got {} and {}", (Object)testExecution1.uniformPath, (Object)testExecution2.uniformPath);
        }
        if ((worstResult = ETestExecutionResult.worst(testExecution1.result, testExecution2.result)) != testExecution1.result) {
            return testExecution1;
        }
        if (worstResult != testExecution2.result) {
            return testExecution2;
        }
        if (testExecution1.getDurationMillis() > testExecution2.getDurationMillis()) {
            return testExecution1;
        }
        return testExecution2;
    }

    public TestExecution copyWithUniformPath(UniformPath uniformPath) {
        return new TestExecution(uniformPath, this.testLocations, this.durationSeconds, this.result, this.message, this.hash, this.externalLink, this.executionUnit, this.associatedSpecItems);
    }

    public static class Builder {
        private static final Pattern UNESCAPED_SLASH = Pattern.compile("(?<!\\\\)/");
        private final UniformPath uniformPath;
        private @Nullable List<String> testLocations;
        private double durationInSeconds = 0.0;
        private ETestExecutionResult result;
        private String failureMessage;
        private @Nullable String hash;
        private String externalLink;
        private @Nullable String executionUnit;
        private @Nullable List<String> associatedSpecItems;

        private Builder(UniformPath uniformPath) {
            Preconditions.checkArgument((boolean)uniformPath.isTestExecutionPath(), (Object)("Uniform path for test execution must start with -test-execution- but was " + String.valueOf(uniformPath)));
            this.uniformPath = uniformPath;
        }

        private Builder(RelativeUniformPath uniformPath) {
            Preconditions.checkArgument((!uniformPath.toString().startsWith(UniformPath.EType.TEST_EXECUTION.getPrefix()) ? 1 : 0) != 0, (Object)("Uniform path for test execution must not start with -test-execution- but was " + String.valueOf(uniformPath)));
            this.uniformPath = UniformPath.testExecutionRoot().resolve(uniformPath);
        }

        public static Builder fromClassAndName(String fullyQualifiedClassName, String testName) {
            fullyQualifiedClassName = UNESCAPED_SLASH.matcher(fullyQualifiedClassName).replaceAll(".");
            return Builder.fromPathAndName(Arrays.asList(fullyQualifiedClassName.split("\\.")), testName);
        }

        public static Builder fromUniformPath(String path) {
            return new Builder(UniformPathCompatibilityUtil.convert(Builder.truncateIfNeeded(path)));
        }

        public static Builder fromRelativePath(String path) {
            return new Builder(UniformPathCompatibilityUtil.convertRelative(Builder.truncateIfNeeded(path)));
        }

        private static Builder fromPathAndName(List<String> pathSegments, String testName) {
            return new Builder(RelativeUniformPath.of(CollectionUtils.map(pathSegments, UniformPath::escapeSegment)).addSuffix(UniformPath.escapeSegment(Builder.truncateIfNeeded(testName))));
        }

        public static String truncateIfNeeded(String testName) {
            String testNameFirstLine = StringUtils.getFirstLine((String)testName);
            if (testName.length() <= 400 && testNameFirstLine.length() == testName.length()) {
                return testName;
            }
            int visibleTestCharacters = Math.min(testNameFirstLine.length(), 347);
            return Builder.buildTruncatedTestName(testName.substring(0, visibleTestCharacters), testName.substring(visibleTestCharacters));
        }

        public static @NonNull String buildTruncatedTestName(String prefix, String truncatedPart) {
            return prefix + "[hashed parameters: " + Builder.hashToString(truncatedPart) + "]";
        }

        private static @NonNull String hashToString(String testParameter) {
            return Hashing.murmur3_128().hashString((CharSequence)testParameter, StandardCharsets.UTF_8).toString();
        }

        public Builder fromBuilder(UniformPath uniformPath) {
            Builder builder = new Builder(uniformPath);
            builder.setDurationInSeconds(this.durationInSeconds);
            builder.setResult(this.result);
            builder.setHash(this.hash);
            builder.setFailureMessage(this.failureMessage);
            builder.setExternalLink(this.externalLink);
            builder.setExecutionUnit(this.executionUnit);
            builder.setAssociatedSpecItems(this.associatedSpecItems);
            builder.setTestLocations(this.testLocations);
            return builder;
        }

        public Builder setFailureMessage(String failureMessage) {
            if (failureMessage != null && !(failureMessage = StringUtils.removeWhitespaceAtBeginningOfLine((String)failureMessage.trim())).isEmpty()) {
                this.failureMessage = failureMessage;
            }
            return this;
        }

        public Builder setDuration(Duration duration) {
            return this.setDurationInSeconds((double)duration.toMillis() / 1000.0);
        }

        public Builder setDurationInSeconds(double durationInSeconds) {
            this.durationInSeconds = durationInSeconds;
            return this;
        }

        public Builder setResult(ETestExecutionResult result) {
            this.result = result;
            return this;
        }

        public Builder setHash(@Nullable String hash) {
            this.hash = hash;
            return this;
        }

        public Builder setExternalLink(String externalLink) {
            this.externalLink = externalLink;
            return this;
        }

        public Builder setExecutionUnit(String executionUnit) {
            this.executionUnit = executionUnit;
            return this;
        }

        public Builder setAssociatedSpecItems(List<String> associatedSpecItems) {
            this.associatedSpecItems = associatedSpecItems;
            return this;
        }

        public TestExecution build() {
            return new TestExecution(this.uniformPath, this.testLocations, this.durationInSeconds, this.result, this.failureMessage, this.hash, this.externalLink, this.executionUnit, this.associatedSpecItems);
        }

        public UniformPath getUniformPath() {
            return this.uniformPath;
        }

        public Builder setTestLocations(@Nullable List<String> testLocations) {
            this.testLocations = testLocations;
            return this;
        }
    }
}

