import{_ as r,h as i,ak as s,j as t,x as o,O as n,L as c,g as l}from"./chunks/framework.B7a_7emw.js";const p="/assets/azure-devops-badge.BypJUeUZ.png",u="/assets/azure-devops-configure-teamscale-as-required-check.Ba-0G0UC.png",h="/assets/azure-devops-web-hooks.CHPJKibN.png",d="/assets/azure-devops-web-hooks-service.CSFSYa9p.png",m="/assets/azure-devops-web-hooks-trigger.Y4rvl_r1.png",g="/assets/azure-devops-web-hooks-action.Cueo-VOP.png",S=JSON.parse('{"title":"Connecting to Azure DevOps Git","description":"","frontmatter":{"title":"Connecting to Azure DevOps Git"},"headers":[],"relativePath":"howto/connecting-version-control-system/azure-devops-git/index.md","filePath":"howto/connecting-version-control-system/azure-devops-git/index.md"}'),f={name:"howto/connecting-version-control-system/azure-devops-git/index.md"},v={class:"warning custom-block"};function b(k,e,w,z,y,T){const a=c("Badge");return l(),i("div",null,[e[8]||(e[8]=s('<h1 id="how-to-connect-teamscale-to-azure-devops-git" tabindex="-1">How to Connect Teamscale to Azure DevOps Git <a class="header-anchor" href="#how-to-connect-teamscale-to-azure-devops-git" aria-label="Permalink to &quot;How to Connect Teamscale to Azure DevOps Git&quot;">​</a></h1><p><img src="'+p+'" alt="Screenshot of the Azure DevOps Plugin&#39;s Findings Badge" width="884" height="374" data-zoom="true"></p><p>Teamscale integrates with Azure DevOps Server and Azure DevOps Services using the available API and web hooks. No changes to Azure DevOps admin settings are required.</p><div class="tip custom-block"><p class="custom-block-title">General Option Reference</p><p>This guide only covers the options specific for the Azure DevOps Git repository connector. A general overview of connector options is <a href="./../../../reference/connector-options/">available here</a>.</p></div><div class="tip custom-block"><p class="custom-block-title">Organization, Project and Repository</p><p>Git URLs in Azure DevOps usually look like this: <code>https://dev.azure.com/{organization}/{project}/_git/{repository}</code>.</p><p>It is common to work on one or more projects within a single organization. Each project can have multiple Git repositories. The default Git repository has the same name as the project.</p><p>Make sure you identify the relevant parts of the repository you want to connect to before starting with this How-To.</p></div><h2 id="configuring-azure-devops" tabindex="-1">Configuring Azure DevOps <a class="header-anchor" href="#configuring-azure-devops" aria-label="Permalink to &quot;Configuring Azure DevOps&quot;">​</a></h2><p>Create a technical user that Teamscale can use to connect to Azure DevOps. It must have the <em>Edit Subscriptions</em> and <em>View Subscriptions</em> permissions. By default, these permissions are <a href="https://learn.microsoft.com/en-us/azure/devops/organizations/security/permissions?view=azure-devops&amp;tabs=preview-page" target="_blank" rel="noreferrer">only granted to Project Administrators</a>. Teamscale uses these permissions to create web hooks in Azure DevOps. If you cannot grant these permissions to the Teamscale user, you must <a href="#manual-setup-of-web-hooks">manually create the webhooks</a>.</p><p>Create an access token for this user with the <em>Read &amp; Write</em> and <em>Status</em> permissions for the <em>Code</em> scope.</p><h3 id="azure-devops-server" tabindex="-1">Azure DevOps Server <a class="header-anchor" href="#azure-devops-server" aria-label="Permalink to &quot;Azure DevOps Server&quot;">​</a></h3><p>If you have enabled <em>Basic Authentication</em> in your IIS, <a href="https://learn.microsoft.com/en-us/azure/devops/organizations/accounts/use-personal-access-tokens-to-authenticate?view=azure-devops&amp;tabs=Windows#q-why-did-my-pat-stop-working" target="_blank" rel="noreferrer">personal access tokens will not work</a>. Use username and password instead.</p><p><a href="https://learn.microsoft.com/da-dk/azure/devops/integrate/get-started/authentication/iis-basic-auth?view=azure-devops&amp;viewFallbackFrom=vsts" target="_blank" rel="noreferrer">Microsoft recommends turning <em>Basic Authentication</em> off</a>.</p><h2 id="configuring-teamscale" tabindex="-1">Configuring Teamscale <a class="header-anchor" href="#configuring-teamscale" aria-label="Permalink to &quot;Configuring Teamscale&quot;">​</a></h2><ol><li><p>Ensure that the <a href="./../../../reference/admin-settings/server-settings/#teamscale-instance-base-url">Teamscale instance base URL</a> is configured correctly.</p></li><li><p>Select the <em>Azure DevOps Git</em> connector during project creation.</p></li><li><p>Select or create an account for the Azure DevOps instance. The account&#39;s fields should be filled out as follows:</p><p>The <em>URI</em> is set according to the type of the Azure DevOps instance:</p><ul><li>Azure DevOps Services: <code>https://dev.azure.com/{organization}</code></li><li>Azure DevOps Server: <code>https://{instance}/{collection}</code></li></ul><p>In most cases, leave the <em>Username</em> field empty and enter the access token you created above into the <em>Password</em> field. However, if you connect to Azure DevOps Server and <a href="#azure-devops-server">configured it to accept authentication via username and password</a>, enter the username and password into these fields.</p></li><li><p>Set the <em>Repository name</em> to the name of the Azure DevOps project and repository separated by a slash: <code>{project}/{repository}</code> Even if the project and repository names are the same, the input must be in above format (e.g., <code>MyProject/MyProject</code>).</p></li></ol>',13)),t("div",v,[e[6]||(e[6]=t("p",{class:"custom-block-title"},"Azure DevOps Server: authentication not supported",-1)),e[7]||(e[7]=t("p",null,[o("If you receive the error message "),t("code",null,"authentication not supported"),o(" it is likely that authentication against the Git repository is tried with NTLM instead of HTTP Basic. There are two workarounds for this:")],-1)),t("ul",null,[t("li",null,[n(a,{text:"recommended",type:"tip"}),e[0]||(e[0]=o("Prefer Basic authentication over NTLM in Teamscale by passing the ",-1)),e[1]||(e[1]=t("code",null,'-Dhttp.auth.preference="basic"',-1)),e[2]||(e[2]=o()),e[3]||(e[3]=t("a",{href:"./../../../reference/administration-ts-installation/#jvm-arguments"},"JVM argument",-1)),e[4]||(e[4]=o(" to Teamscale. Use an access token in Teamscale.",-1))]),e[5]||(e[5]=t("li",null,[o("Or enable Basic authentication in "),t("a",{href:"https://github.com/Microsoft/tfs-cli/blob/master/docs/configureBasicAuth.md#configuring-tfs-to-use-basic-authentication",target:"_blank",rel:"noreferrer"},"IIS Settings"),o(". However, this is "),t("a",{href:"https://learn.microsoft.com/da-dk/azure/devops/integrate/get-started/authentication/iis-basic-auth?view=azure-devops&viewFallbackFrom=vsts",target:"_blank",rel:"noreferrer"},"not recommended by Microsoft"),o(". Use username and password in Teamscale.")],-1))])]),e[9]||(e[9]=s('<p>As the first step during project creation, Teamscale will register its web hook with the Azure DevOps Server. After this, Teamscale will automatically be informed about events in the project, such as pushes to the repository and changes to pull requests.</p><h2 id="configuring-teamscale-as-a-required-check" tabindex="-1">Configuring Teamscale as a Required Check <a class="header-anchor" href="#configuring-teamscale-as-a-required-check" aria-label="Permalink to &quot;Configuring Teamscale as a Required Check&quot;">​</a></h2><p><img src="'+u+'" alt="Screenshot describing procedure to configure Teamscale as a required check" width="2218" height="1049" data-zoom="true"> If Teamscale is configured to vote on pull requests, you can require that all findings are addressed before a pull request is merged:</p><ol><li><p>In Azure DevOps, go to <em>Project Settings</em> &gt; <em>Repositories</em> and select the repository connected to Teamscale.</p></li><li><p>Select <em>Policies</em> and the default integration branch, e.g. <code>master</code>.</p></li><li><p>Add a new <em>Status Check</em> and select <em>Teamscale</em> from the dropdown.</p></li></ol><h2 id="manual-setup-of-web-hooks" tabindex="-1">Manual Setup of Web Hooks <a class="header-anchor" href="#manual-setup-of-web-hooks" aria-label="Permalink to &quot;Manual Setup of Web Hooks&quot;">​</a></h2><p>If there are restrictions, so that Teamscale cannot receive Azure DevOps web hooks or web hooks cannot be automatically created, please apply these <a href="./../../configuring-post-commit-hooks/#code-collaboration-platforms">advanced Teamscale configuration options</a>. These prevent Teamscale from trying to create the webhooks which will otherwise cause Teamscale project validation to fail.</p><p>In case web hooks can be received but the user account Teamscale uses to access Azure DevOps does not have sufficient privileges to create the web hooks, the web hooks need to be manually created once by an Azure DevOps project administrator. Three web hooks need to be created for the following events:</p><ul><li><em>Code pushed</em></li><li><em>Pull request created</em></li><li><em>Pull request updated</em></li></ul><p>To create these hooks:</p><ol><li><p>In Azure DevOps, go to <em>Project Settings</em> &gt; <em>Service Hooks</em>.</p><p><img src="'+h+'" alt="Configuration of Azure DevOps web hooks" width="674" height="273" data-zoom="true"></p></li><li><p>Click the <em>PLUS</em> icon in the top left and select <em>Web Hooks</em> as service type. Click <em>Next</em>.</p><p><img src="'+d+'" alt="Add Web Hook Service" width="600" height="600"></p></li><li><p>Configure the service hook trigger</p><ul><li>Select <em>Code pushed</em> as event type (1).</li><li>Select the repository for which events will be triggered (2).</li><li>In case the Azure DevOps project contains more than one repository, you either have to select <em>[Any]</em> to trigger events for all repositories, or you have to set up hooks for each individual repository separately.</li><li>Click <em>Next</em>.</li></ul><p><img src="'+m+'" alt="Configure Web Hook Trigger" width="602" height="601" data-zoom="true"></p></li><li><p>Configure the service hook action</p><ul><li>Enter the <em>URL</em> of the Teamscale web hook endpoint (1). The URL should be as follows: <code>https://{teamscale-url}/api/azure-devops-git/web-hook</code>.</li><li>If you use HTTPS with a self-signed certificate, <em>Accept untrusted SSL certificates</em> should also be checked (2).</li><li>Click <em>Test</em> to verify that the hook has been created successfully.</li><li>Click <em>Finish</em>.</li></ul><p><img src="'+g+'" alt="Configure Web Hook Action" width="579" height="943"></p></li><li><p>Repeat steps 2-4 also for event types <em>Pull request created</em> and <em>Pull request updated</em>.</p></li></ol>',10))])}const O=r(f,[["render",b]]);export{S as __pageData,O as default};
