import{_ as t}from"./chunks/bitbucket-server-inline-comments.HrvkQRR1.js";import{_ as o,h as a,ak as s,g as i}from"./chunks/framework.B7a_7emw.js";const n="/assets/bitbucket-server-badges.Sp5mn-ks.png",r="/assets/bitbucket-cloud-report.BxkJN5Ql.png",l="/assets/bitbucket-cloud-inline-comments.Cv4cdWy-.png",c="/assets/bitbucket-server-quality-report.BXMR0goy.png",u="/assets/screenshot_bitbucket_server_1_issue_preventing_you_from_merging.iVRguMJh.png",w=JSON.parse('{"title":"Connecting to Bitbucket","description":"","frontmatter":{"title":"Connecting to Bitbucket"},"headers":[],"relativePath":"howto/connecting-version-control-system/bitbucket/index.md","filePath":"howto/connecting-version-control-system/bitbucket/index.md"}'),p={name:"howto/connecting-version-control-system/bitbucket/index.md"};function h(m,e,d,g,b,k){return i(),a("div",null,[...e[0]||(e[0]=[s('<h1 id="how-to-connect-teamscale-to-bitbucket" tabindex="-1">How to Connect Teamscale to Bitbucket <a class="header-anchor" href="#how-to-connect-teamscale-to-bitbucket" aria-label="Permalink to &quot;How to Connect Teamscale to Bitbucket&quot;">​</a></h1><p>Teamscale can connect to both the Bitbucket Cloud version and the Bitbucket Data Center (On-Premise) version.</p><div class="tip custom-block"><p class="custom-block-title">General Option Reference</p><p>This guide only covers the options specific for the Bitbucket Cloud/Data Center repository connector. A general overview of connector options is <a href="./../../../reference/connector-options/">available here</a>.</p></div><p><img src="'+n+'" alt="Screenshot of the Bitbucket Plugin&#39;s Findings Badge" width="1133" height="914" data-zoom="true"></p><nav class="table-of-contents"><ul><li><a href="#bitbucket-cloud-integration">Bitbucket Cloud Integration</a></li><li><a href="#bitbucket-data-center-on-premise-integration">Bitbucket Data Center (On-Premise) Integration</a><ul><li><a href="#required-permissions">Required Permissions</a></li><li><a href="#manual-creation-of-webhooks">Manual Creation of Webhooks</a></li><li><a href="#blocking-pull-requests-using-teamscale">Blocking Pull Requests using Teamscale</a></li></ul></li></ul></nav><h2 id="bitbucket-cloud-integration" tabindex="-1">Bitbucket Cloud Integration <a class="header-anchor" href="#bitbucket-cloud-integration" aria-label="Permalink to &quot;Bitbucket Cloud Integration&quot;">​</a></h2><p>Teamscale integrates with Bitbucket Cloud as a <em>Bitbucket App</em>. Please note that this is currently a beta feature. Prerequisites for the configuration are:</p><ul><li>Teamscale installation that can be reached from the Bitbucket Cloud instance you want to connect to.</li><li>Bitbucket workspace used to register the Bitbucket App. Please note that this app needs to be installed on the workspace, so that Teamscale has access to all available repositories of your workspace.</li></ul><p><img src="'+r+'" alt="Screenshot of the Bitbucket Cloud Plugin&#39;s Report" width="962" height="750" data-zoom="true"></p><p>To connect to Bitbucket cloud, the following steps are needed:</p><ol><li><p>Ensure that the <a href="./../../../reference/admin-settings/server-settings/#teamscale-instance-base-url">Teamscale instance base URL</a> is configured correctly.</p></li><li><p>In Bitbucket, navigate to the settings page of your workspace. Open <em>Installed apps</em> and click the link <em>Install app from URL</em>. You might also need to enable the development mode on the bottom of the page. Here you can provide the App URL to directly install the app.</p><ul><li><strong><em>App URL</em></strong>: This is the public URL of your Teamscale installation followed by <code>api/bitbucket-cloud/app/install</code>. So for the sample Teamscale URL <em><a href="https://teamscale.acme.com" target="_blank" rel="noreferrer">https://teamscale.acme.com</a></em>, this would be <em><a href="https://teamscale.acme.com/api/bitbucket-cloud/app/install" target="_blank" rel="noreferrer">https://teamscale.acme.com/api/bitbucket-cloud/app/install</a></em>.</li></ul></li><li><p>After clicking <em>Install</em>, the app will request access to Bitbucket. Click <em>Grant access</em>. You will get a message that the app has been successfully installed and will appear in the list of installed apps.</p></li></ol><div class="tip custom-block"><p class="custom-block-title">No Automatic Project Mirroring</p><p>Note that Teamscale projects are not automatically created, but rather have to be created as needed using the Bitbucket connector after the app has been installed.</p><p>Set the <em>repository name</em> option in the connector to <code>projectKey/repoSlug</code>.</p></div><p><img src="'+l+'" alt="Screenshot of the Bitbucket Cloud Plugin&#39;s Line Comments" width="2526" height="1318" data-zoom="true"></p><p>When testing Teamscale on a local laptop or during initial setup, a service for exposing local ports on the internet can be helpful. One such service is <a href="https://ngrok.com/" target="_blank" rel="noreferrer">ngrok</a>.</p><h2 id="bitbucket-data-center-on-premise-integration" tabindex="-1">Bitbucket Data Center (On-Premise) Integration <a class="header-anchor" href="#bitbucket-data-center-on-premise-integration" aria-label="Permalink to &quot;Bitbucket Data Center (On-Premise) Integration&quot;">​</a></h2><p>Teamscale integrates with Bitbucket Data Center (On-Premise) using the available API and webhooks.</p><div class="info custom-block"><p class="custom-block-title">Bitbucket Server Integration</p><p>Teamscale still supports Bitbucket Server as well. The minimum required Bitbucket Server version for the integration to work is <strong>7.0.0</strong>.</p></div><p>To connect a project to code from a Bitbucket project, you don&#39;t need to install plugins in Bitbucket or change admin settings. You just need to follow these steps:</p><ol><li><p>Ensure that the <a href="./../../../reference/admin-settings/server-settings/#teamscale-instance-base-url">Teamscale instance base URL</a> is configured correctly.</p></li><li><p>Select the <code>Bitbucket Data Center (On-Premise)</code> connector during project creation.</p></li><li><p>Select or create an account for the Bitbucket server. The account&#39;s fields should be filled out as follows:</p><ul><li><strong><em>URI</em></strong>: Bitbucket server&#39;s root URL (e.g., <code>https://bitbucket.example.com</code>).</li><li><strong><em>Username</em></strong> and <strong><em>Password/Access Token</em></strong> depend on the authentication mode: <ul><li><em>Basic authentication</em>: <ul><li><strong><em>Username</em></strong>: The username of a user who has <strong>admin</strong> permissions for the repository.</li><li><strong><em>Password/Access Token</em></strong>: The user&#39;s password or personal HTTP access token with at least <strong>Project read</strong> and <strong>Repository admin</strong> permissions.</li></ul></li><li><em>Bearer authentication</em>: <ul><li><strong><em>Username</em></strong>: Must be empty.</li><li><strong><em>Password/Access Token</em></strong>: An HTTP access token with at least <strong>Project read</strong> and <strong>Repository admin</strong> permissions.</li></ul></li></ul></li></ul></li><li><p>Complete project creation as usual, by providing the full name of the Bitbucket repository and completing any other required fields. The name should be in this format <code>projectKey/repoSlug</code>.</p></li></ol><div class="info custom-block"><p class="custom-block-title">HTTP Access Tokens in Bitbucket Data Center</p><p>There are three different types of HTTP access tokens: personal access tokens that belong to a user, repository access tokens and project access tokens that allow access to a specific repository or project. To obtain an access token in Bitbucket, select the <em>HTTP access tokens</em> page from</p><ul><li>your user&#39;s <em>Manage account</em> page for a personal access token.</li><li>the repository&#39;s settings page for a repository access token.</li><li>the project&#39;s settings page for a project access token.</li></ul></div><p>As the first step in project creation, Teamscale will register its webhook with the project. After this, Teamscale will automatically be informed about events in the project, such as pushes to the repository and changes to any pull requests.</p><p><img src="'+t+'" alt="Screenshot of the Bitbucket Plugin&#39;s Line Comments" width="1040" height="748" data-zoom="true"><img src="'+c+'" alt="Screenshot of the Bitbucket Quality Report" width="1040" height="748" data-zoom="true"></p><h3 id="required-permissions" tabindex="-1">Required Permissions <a class="header-anchor" href="#required-permissions" aria-label="Permalink to &quot;Required Permissions&quot;">​</a></h3><p>It is required that the technical user has <strong>admin</strong> permissions for the repository. These permissions are needed for Teamscale to automatically create the necessary webhooks in the Bitbucket repository.</p><p>In case administrative rights cannot be granted to the technical user, please do the following:</p><ol><li>Disable automatic webhook creation by setting the corresponding expert option of the repository connector. You can also set the default of this option for new projects by passing the following <a href="./../../../reference/administration-ts-installation/#jvm-arguments">JVM argument</a> on the start of Teamscale: <code>-Dcom.teamscale.mergerequest.disable-automatic-webhook-creation-default=true</code></li><li>Manually <a href="#manual-creation-of-webhooks">create the necessary webhooks</a> in Bitbucket.</li></ol><p>Even if the technical user may not be granted administrative rights or if they are taken away after the initial webhook setup, the user still requires write permissions. These permissions enable Teamscale to edit pull request descriptions. If the user lacks these permissions, Teamscale may not enhance pull requests with finding information.</p><h3 id="manual-creation-of-webhooks" tabindex="-1">Manual Creation of Webhooks <a class="header-anchor" href="#manual-creation-of-webhooks" aria-label="Permalink to &quot;Manual Creation of Webhooks&quot;">​</a></h3><p>In case the technical user does not have administrative rights, you will need to manually create and configure webhooks in the Bitbucket repository.</p><ol><li>Open the Bitbucket repository you want to add the webhook to.</li><li>From <em>Repository settings</em>, click <em>Webhooks</em>.</li><li>Click the <em>Create webhook</em> button.</li><li>Configure the webhook as follows: <ul><li><strong><em>Name</em></strong>: Enter any name for the webhook (e.g. &quot;Teamscale Webhook&quot;).</li><li><strong><em>URL</em></strong>: Enter the URL of Teamscale&#39;s Bitbucket endpoint. It should be in the following format: <code>{Teamscale_baseURL}/api/bitbucket-server/web-hook</code></li><li><strong><em>Events</em></strong>: Select the following events: <ul><li>Repository: Push</li><li>Pull request: Opened, Source branch updated, Modified, Merged, Declined, Deleted</li></ul></li></ul></li><li>Click <em>Create</em>.</li></ol><div class="tip custom-block"><p class="custom-block-title">TIP</p><p>If there are restrictions, so that Teamscale cannot receive Bitbucket webhooks, please apply these <a href="./../../configuring-post-commit-hooks/#code-collaboration-platforms">advanced configuration options</a>.</p></div><h3 id="blocking-pull-requests-using-teamscale" tabindex="-1">Blocking Pull Requests using Teamscale <a class="header-anchor" href="#blocking-pull-requests-using-teamscale" aria-label="Permalink to &quot;Blocking Pull Requests using Teamscale&quot;">​</a></h3><p>Although blocking the merge of pull requests in case of findings or test gaps is <strong>not recommended</strong> in general, it is possible to configure such a &quot;quality gate&quot; using the <a href="./../../../reference/connector-options/#bitbucket-server-options">Bitbucket Server Options</a>. In some cases, a soft quality gate that can be overruled by the developers of a project is necessary. For example, there often are test gaps that are neither worth the effort (time- or resource-wise) nor relevant given the context of a pull request that otherwise would block the merge.</p><p><img src="'+u+'" alt="Screenshot of a missing approval by a reviewer in a Bitbucket Pull Request" width="449" height="179"></p><p>To achieve such a soft quality gate, you have to enable the options</p><ul><li><strong>Enable Test Gap Integration for Merge Requests</strong>,</li><li><strong>Enable Voting for Findings / Test Gaps /Test Coverage</strong> and</li><li><strong>Enable pull request review (expert option)</strong></li></ul><p>in the Teamscale project configuration. Additionally, you have to enable Bitbucket&#39;s merge check &quot;Minimum approvals&quot; with a minimum number of approvals of the currently required number +1. If it is necessary to overrule the review posted by Teamscale, an additional reviewer can give the required missing approval.</p><p>Alternatively, it is possible to enable Bitbucket&#39;s merge check &quot;All reviewers approve&quot; and remove Teamscale&#39;s review manually in case it should be overruled.</p>',38)])])}const y=o(p,[["render",h]]);export{w as __pageData,y as default};
