import{_ as t,h as d,ak as i,g as o}from"./chunks/framework.B7a_7emw.js";const h=JSON.parse('{"title":"Customizing the Comment Analysis","description":"","frontmatter":{"title":"Customizing the Comment Analysis"},"headers":[],"relativePath":"howto/customizing-comment-analysis/index.md","filePath":"howto/customizing-comment-analysis/index.md"}'),a={name:"howto/customizing-comment-analysis/index.md"};function r(n,e,s,l,c,m){return o(),d("div",null,[...e[0]||(e[0]=[i('<h1 id="how-to-customize-the-comment-analysis" tabindex="-1">How to Customize the Comment Analysis <a class="header-anchor" href="#how-to-customize-the-comment-analysis" aria-label="Permalink to &quot;How to Customize the Comment Analysis&quot;">​</a></h1><p>To customize the <em>code entities</em> (e.g., methods or field declarations) for which Teamscale expects a comment, Teamscale provides so-called <strong>selection predicates</strong> to specify code entities. This can be used to customize and fine-tune the comment analysis to your needs.</p><h3 id="supported-languages" tabindex="-1">Supported Languages <a class="header-anchor" href="#supported-languages" aria-label="Permalink to &quot;Supported Languages&quot;">​</a></h3><p>The following languages support this feature:</p><ul><li>ABAP</li><li>C</li><li>C#</li><li>C++</li><li>Java</li><li>JavaScript</li><li>Kotlin</li><li>MATLAB</li><li>Python</li><li>Swift</li><li>Visual Basic</li></ul><h2 id="code-entity-selection-predicates" tabindex="-1">Code Entity Selection Predicates <a class="header-anchor" href="#code-entity-selection-predicates" aria-label="Permalink to &quot;Code Entity Selection Predicates&quot;">​</a></h2><p>An entity selection predicate consists of primitives that can be connected using negation <code>!</code>, conjunction <code>&amp;</code>, disjunction <code>|</code>, and parentheses <code>(</code> and <code>)</code>. The primitives are listed in the following configuration boxes. Obviously, not all predicates are applicable to all programming languages.</p><h3 id="simple-example" tabindex="-1">Simple Example <a class="header-anchor" href="#simple-example" aria-label="Permalink to &quot;Simple Example&quot;">​</a></h3><p>An example that selects <strong>all public simple getters and setters</strong> would be</p><p><code>public &amp; (simpleGetter | simpleSetter)</code></p><h3 id="language-level-examples" tabindex="-1">Language-level examples <a class="header-anchor" href="#language-level-examples" aria-label="Permalink to &quot;Language-level examples&quot;">​</a></h3><p>A good starting point are the following examples</p><table><tbody><tr><td><strong>Java</strong></td><td><code>public &amp; (type | method | attribute) &amp; !(simpleGetter | simpleSetter | annotated(Override) | override)</code></td></tr><tr><td><strong>C#</strong></td><td><code>public &amp; (type | method | property) &amp; !(simpleGetter | simpleSetter | annotated(Override) | override)</code></td></tr><tr><td><strong>C++<br>(Comments expected in Headers)</strong></td><td><code>type | (public &amp; (attribute | (method &amp; declaration)))</code></td></tr><tr><td><strong>C++<br>(Comments expected at Implementation)</strong></td><td><code>type | (public &amp; (attribute | (method &amp; !declaration)))</code></td></tr><tr><td><strong>Swift</strong></td><td><code>(public &amp; (type | method | attribute | declaration | property) &amp; !(simpleGetter | simpleSetter | annotated(Override) | override))</code></td></tr></tbody></table><h3 id="predicate-reference" tabindex="-1">Predicate Reference <a class="header-anchor" href="#predicate-reference" aria-label="Permalink to &quot;Predicate Reference&quot;">​</a></h3><p>The following boxes provide an overview of the available predicates.</p><table tabindex="0"><thead><tr><th>Predicate</th><th>Meaning</th></tr></thead><tbody><tr><td><code>language(name)</code></td><td>Entities in files with the given language. If the given language name is invalid, no entities are matched. Valid names are for example <code>JAVA</code> and <code>CPP</code>.</td></tr><tr><td><code>module</code></td><td>Namespaces and modules.</td></tr><tr><td><code>type</code></td><td>Types, such as classes or structs.</td></tr><tr><td><code>method</code></td><td>Methods and functions.</td></tr><tr><td><code>declaration</code></td><td>Declarations of types and methods.</td></tr><tr><td><code>internal</code></td><td><em>Internal</em> entities (C# and Swift keyword).</td></tr><tr><td><code>attribute</code></td><td>Attributes, fields and global variables.</td></tr><tr><td><code>property</code></td><td>All properties: defined attributes that have only method children.</td></tr><tr><td><code>statement</code></td><td>All statements.</td></tr><tr><td><code>meta</code></td><td>All meta information (defines, annotations, etc.).</td></tr><tr><td><code>public</code></td><td>All <em>public</em> entities, as well as methods inside interfaces, which are considered public in most languages.</td></tr><tr><td><code>protected</code></td><td>All <em>protected</em> entities.</td></tr><tr><td><code>override</code></td><td>All entities marked with <em>override</em> keyword.</td></tr><tr><td><code>private</code></td><td>All <em>private</em> entities.</td></tr><tr><td><code>fileprivate</code></td><td>All <em>fileprivate</em> entities (Swift keyword).</td></tr><tr><td><code>default</code></td><td>All entities with default visibility.</td></tr><tr><td><code>final</code></td><td>All <em>final</em> entities.</td></tr><tr><td><code>static</code></td><td>All <em>static</em> entities.</td></tr><tr><td><code>primitive</code></td><td>All primitive entities (i.e. those without children).</td></tr><tr><td><code>subtype(name)</code></td><td>Entities by their subtype. The name parameter can e.g., be <code>if</code> to target if-statements. Other examples for the name parameter are <code>constructor</code>, <code>destructor</code> or <code>while</code>.</td></tr><tr><td><code>typeSubtype(name)</code></td><td>Entities by their parent type&#39;s subtype (e.g., to select all members of interfaces).</td></tr><tr><td><code>name(name)</code></td><td>Entities by their name. For example a method name.</td></tr><tr><td><code>nameRegex(regex)</code></td><td>Entities by their name using regular expression.</td></tr><tr><td><code>fileRegex(regex)</code></td><td>Entities by their containing file&#39;s unified path using regular expression, e.g. <code>fileRegex(.*\\.ts)</code> matches all files with the extension ».ts«.</td></tr><tr><td><code>annotated(name)</code></td><td>All entities that are annotated with an annotation of given name (excluding the »@« sign).</td></tr><tr><td><code>simpleGetter</code></td><td>Simple getters, i.e. methods starting with »get« or »is« and containing at most one statement.</td></tr><tr><td><code>simpleSetter</code></td><td>Simple setters, i.e. methods starting with »set« and containing at most one statement.</td></tr><tr><td><code>simpleMethod(prefix)</code></td><td>Simple methods whose name starts with the given prefix. A method is simple, if it contains as most one statement. Use <code>simpleMethodCaseInsensitive(prefix)</code> for a case insensitive version.</td></tr><tr><td><code>export</code></td><td>All entities with ES6&#39;s <code>export</code> visibility.</td></tr><tr><td><code>typeexported</code></td><td>All entities (e.g. methods, attributes) within types that have ES6&#39;s export visibility.</td></tr><tr><td><code>extendsType</code></td><td>Classes that extend a specific type directly (e.g. <code>extendsType(MyBaseClass)</code>)</td></tr><tr><td><code>isAbstract</code></td><td>All <em>abstract</em> entities.</td></tr><tr><td><code>redefinition</code></td><td>Only for ABAP: all entities with a redefinition modifier</td></tr></tbody></table>',16)])])}const u=t(a,[["render",r]]);export{h as __pageData,u as default};
