import{_ as o,h as t,ak as n,g as s}from"./chunks/framework.B7a_7emw.js";const c="/assets/analysis-profile-checks.C-1_MmNa.png",i="/assets/analysis-profile-options.MJn2fsrE.png",a="/assets/findings.CWJKC53f.png",r="/assets/metrics.D8tQ0LE6.png",b=JSON.parse('{"title":"Detecting cross component clones","description":"","frontmatter":{"title":"Detecting cross component clones"},"headers":[],"relativePath":"howto/detecting-cross-component-clones/index.md","filePath":"howto/detecting-cross-component-clones/index.md"}'),l={name:"howto/detecting-cross-component-clones/index.md"};function d(h,e,m,p,u,f){return s(),t("div",null,[...e[0]||(e[0]=[n('<h1 id="how-to-detect-cross-component-clones" tabindex="-1">How to Detect Cross Component Clones <a class="header-anchor" href="#how-to-detect-cross-component-clones" aria-label="Permalink to &quot;How to Detect Cross Component Clones&quot;">​</a></h1><p>Teamscale&#39;s clone detection allows detecting so-called <em>cross component clones</em>. A component, in this context, refers to a component as per Teamscale&#39;s architecture conformance model and can essentially be an arbitrary subset of the code within a Teamscale project. This feature enables distinguishing between clones with clone relationships across the boundaries of certain code areas (<em>cross component clones</em>) and those that only have clone relationships within a code area (<em>intra component clones</em>). An example would be a situation where the code of a component (or project) was forked from another one, and you are interested in the commonalities between the two components.</p><div class="tip custom-block"><p class="custom-block-title">TIP</p><p>A clone is a <em>cross component clones</em> as soon as <strong>any of its siblings</strong> is located in another component as per the cross component clone detection architecture. A clone is an intra component clone if <strong>all of its siblings</strong> are located in the same component as per the cross component clone architecture.</p></div><p>For cross component clone detection, Teamscale provides two dedicated finding types: <em>Cross Component Clones</em> and <em>Intra Component Clones</em>. In addition, the corresponding metrics <em>Cross Component Clone Coverage</em> and <em>Intra Component Clone Coverage</em> are provided. To enable cross component clone detection, have a look at the analysis profile. In the analysis group <code>Redundancy ❯ Code Clones</code> (see screenshot below), you find three checks for the different clone types. Activate cross or intra component clones here, or both, to get clone findings for the respective clone type. Note that plain clones cannot be activated in that case.</p><p><img src="'+c+'" alt="Analysis Profile Group" width="902" height="456" data-zoom="true"></p><p>You can access additional related options by clicking the gear symbol next to the <code>Code Clones</code> group (left side in the above screenshot). In the upcoming dialog (see screenshot below), you can enable the mentioned clone coverage metrics and specify the name of the architecture file that defines the components to use for component-based clone detection. Feel free to keep the provided default file name. Please note that <strong>providing an architecture model is mandatory</strong> for component-based clone detection, i.e., an architecture model with the name specified here must exist in the project. If the architecture model does not exist, the component-based clone detection will not detect any clones or will report all clones as intra component clones until the model becomes available.</p><p><img src="'+i+'" alt="Analysis Profile Options" width="672" height="477" data-zoom="true"></p><div class="tip custom-block"><p class="custom-block-title">TIP</p><p>When using component-based clone detection, the <em>normal</em> clone detection cannot be used at the same time. Thus, when enabling cross or intra component options, the <em>Clones</em> finding option has to be disabled. The Clone Coverage metric can still be used and will refer to the clone coverage of all clones (both cross and intra component clones).</p></div><p><img src="'+a+'" alt="Cross Component Clone Findings" width="281" height="111"></p><p><img src="'+r+'" alt="Cross Component Clone Coverage" width="463" height="121"></p><div class="tip custom-block"><p class="custom-block-title">TIP</p><p>The architecture used for component-based clone detection has to be a <strong>file-based</strong> architecture. It is recommended to set the Finding Creation option to <code>None</code> for this architecture and, thus, exclusively use it for component-based clone detection.</p></div><p>Component-based clones will be detected as soon as the configured architecture model exists in the project history. If you want to analyse component-based clones for the history of a project, the architecture model has to be added in time-travel model to the project&#39;s commit history in Teamscale.</p><p>Please note that both the cross component findings and the cross component clone coverage are sensitive regarding changes to the architecture model used for the detection. The same applies to intra component clones and intra component clone coverage. Thus, changing the architecture model may result in findings being removed from one clone finding type and added to the other. Similarly, both metrics can change. Note again that this will only affect the findings/metrics from the point in time on when the change to the architecture takes place. If you want to alter the component definition in the project history, the architecture needs to be edited in time-travel mode.</p><h2 id="exclusive-intra-component-detection-alternative-detection-mode" tabindex="-1">Exclusive Intra Component Detection (Alternative Detection Mode) <a class="header-anchor" href="#exclusive-intra-component-detection-alternative-detection-mode" aria-label="Permalink to &quot;Exclusive Intra Component Detection (Alternative Detection Mode)&quot;">​</a></h2><p>In addition to the normal cross component clone detection as described above, there is an alternative mode for the <em>exclusive</em> detection of intra component clones. This mode can be enabled in the Code Clone options described above (see screenshot). If the exclusive intra component detection is enabled, cross component clones cannot be detected anymore. Hence, cross component clone coverage and cross component clone findings must be disabled in the analysis profile.</p><p>In this mode, all code that does not reside in a component, as defined by the component-based clone analysis architecture, is ignored and no clones within such code will be detected. For each detected clone, its component is reported in addition to the normal clone properties such as location, instance count, and length. The exclusive mode supports shared code between components, i.e., a file may be included in more than one component. This can be configured by enabling the structure only mode in the used component-based clone detection architecture. For clone siblings that reside in shared files, only one joint clone finding for all involved components is created per location, and the involved components are listed in their properties.</p>',16)])])}const v=o(l,[["render",d]]);export{b as __pageData,v as default};
