import{_ as a,h as i,ak as s,g as t}from"./chunks/framework.B7a_7emw.js";const n="/assets/select-user-for-service.ClbAo0QX.png",l="/assets/cppcheck-premium-verify.BEKvHDdB.png",g=JSON.parse('{"title":"Setting Up External Tools & Formats","description":"An overview of how to configure external analysis tools like Clang, ESLint or abaplint with Teamscale.","frontmatter":{"title":"Setting Up External Tools & Formats","description":"An overview of how to configure external analysis tools like Clang, ESLint or abaplint with Teamscale."},"headers":[],"relativePath":"howto/setting-up-external-tools/index.md","filePath":"howto/setting-up-external-tools/index.md"}'),o={name:"howto/setting-up-external-tools/index.md"};function r(h,e,p,c,d,u){return t(),i("div",null,[...e[0]||(e[0]=[s(`<h1 id="how-to-set-up-external-tools-formats" tabindex="-1">How to Set Up External Tools &amp; Formats <a class="header-anchor" href="#how-to-set-up-external-tools-formats" aria-label="Permalink to &quot;How to Set Up External Tools &amp; Formats&quot;">​</a></h1><nav class="table-of-contents"><ul><li><a href="#bandit">Bandit</a></li><li><a href="#clang-static-analyzer">Clang Static Analyzer</a></li><li><a href="#clang-tidy">Clang-Tidy</a></li><li><a href="#cppcheck-open-source">Cppcheck (open-source)</a></li><li><a href="#cppcheck-premium">Cppcheck Premium</a><ul><li><a href="#setup">Setup</a></li><li><a href="#license">License</a></li></ul></li><li><a href="#findbugs-and-spotbugs">FindBugs and SpotBugs</a></li><li><a href="#flake8">Flake8</a></li><li><a href="#jacoco">JaCoCo</a></li><li><a href="#cobertura">Cobertura</a></li><li><a href="#gcov">gcov</a></li><li><a href="#eslint">ESLint</a></li><li><a href="#sonarlint-for-javascript-typescript">SonarLint for JavaScript / TypeScript</a></li><li><a href="#tslint">TSLint</a></li><li><a href="#abaplint">abaplint</a></li><li><a href="#pc-lint-flexelint">PC-lint/FlexeLint</a></li><li><a href="#pylint">Pylint</a></li><li><a href="#parasoft-c-c-test">Parasoft C/C++test</a></li><li><a href="#powershell-script-analyzer-psscriptanalyzer">PowerShell Script Analyzer (PSScriptAnalyzer)</a></li><li><a href="#xcode-test-coverage">XCode Test Coverage</a><ul><li><a href="#xcode-xctest-test-execution-data">XCode XCTest test execution data</a></li></ul></li><li><a href="#bullseyecoverage">BullseyeCoverage</a></li><li><a href="#swiftlint">SwiftLint</a></li><li><a href="#semgrep">Semgrep</a></li><li><a href="#dart-lint">Dart Lint</a></li><li><a href="#golangci-lint">Golangci-lint</a></li><li><a href="#phpstan">PHPStan</a></li></ul></nav><h2 id="bandit" tabindex="-1">Bandit <a class="header-anchor" href="#bandit" aria-label="Permalink to &quot;Bandit&quot;">​</a></h2><p>Bandit is integrated into Teamscale as an internal analysis tool. Our docker-image distributions contain the correct bandit version, but distributions based on zip-files do not contain it. Instead, you will need to install Bandit on your machine. The required Bandit version is 1.7.7.</p><p>In addition, you will need to have a Python 3 distribution installed with the <code>python3</code> executable on the <code>PATH</code>. This is included in our docker-image distributions as well.</p><h2 id="clang-static-analyzer" tabindex="-1">Clang Static Analyzer <a class="header-anchor" href="#clang-static-analyzer" aria-label="Permalink to &quot;Clang Static Analyzer&quot;">​</a></h2><p>The Open Source LLVM clang compiler includes <a href="http://clang-analyzer.llvm.org/" target="_blank" rel="noreferrer">a static analyzer</a> that performs dataflow analysis on C/C++ code. Analysis is started using the <code>scan-build</code> script, which wraps the make process. To enable output in <strong>plist</strong> format (which we require), the option <code>-plist</code> must be passed to the scan-build command. Additionally, you might want to enable additional checkers using the <code>-enable-checker</code> command. To obtain a list of all available checkers, run the following command:</p><div class="language-bash vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">bash</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">clang</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> -cc1</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> -analyzer-checker-help</span></span></code></pre></div><p>Note that it is sufficient to provide a package/category to the analyzer to enable more checks. A typical invocation of the static analyzer might look like this:</p><div class="language-bash vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">bash</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">scan-build</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> -plist</span></span>
<span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">-enable-checker</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> alpha</span></span>
<span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">-enable-checker</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> core</span></span>
<span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">-enable-checker</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> cplusplus</span></span>
<span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">-enable-checker</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> deadcode</span></span>
<span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">-enable-checker</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> security</span></span>
<span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">-enable-checker</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> unix</span></span>
<span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">make</span></span></code></pre></div><p>To upload analysis results, you should use the <code>external-report</code> service as described in <a href="./../uploading-external-data/">our article on external uploads</a>.</p><h2 id="clang-tidy" tabindex="-1">Clang-Tidy <a class="header-anchor" href="#clang-tidy" aria-label="Permalink to &quot;Clang-Tidy&quot;">​</a></h2><p>While Clang-Tidy is integrated as an internal analysis tool, the Clang-Tidy binaries are generally not shipped with Teamscale. Our docker-image distributions contain the correct clang-tidy version, but distributions based on zip-files do not contain clang-tidy. Instead, you will need to install <a href="https://github.com/llvm/llvm-project/releases/tag/llvmorg-17.0.6" target="_blank" rel="noreferrer">clang-tidy 17.0.6</a> on your machine. More details are <a href="./../../troubleshooting/#wrong-version-of-clang-tidy-or-llvm">described here</a>.</p><h2 id="cppcheck-open-source" tabindex="-1">Cppcheck (open-source) <a class="header-anchor" href="#cppcheck-open-source" aria-label="Permalink to &quot;Cppcheck (open-source)&quot;">​</a></h2><p>While Cppcheck is integrated as an internal analysis tool, the Cppcheck binaries are generally not shipped with Teamscale. Our docker-image distributions contain the correct Cppcheck version, but distributions based on zip-files do not contain Cppcheck. Instead, you will need to install <a href="https://github.com/danmar/cppcheck/releases/tag/2.17.1" target="_blank" rel="noreferrer">cppcheck-2.17.1</a> on your machine.</p><p>You will need to have the python 3 on the <code>PATH</code> to execute the MISRA checks of Cppcheck. This is included in our docker-image distributions as well.</p><p>More details are <a href="./../../troubleshooting/#wrong-version-of-cppcheck">described here</a>.</p><h2 id="cppcheck-premium" tabindex="-1">Cppcheck Premium <a class="header-anchor" href="#cppcheck-premium" aria-label="Permalink to &quot;Cppcheck Premium&quot;">​</a></h2><p>In addition to <a href="#cppcheck">Cppcheck (open-source)</a>, Teamscale also integrates Cppcheck Premium.</p><h3 id="setup" tabindex="-1">Setup <a class="header-anchor" href="#setup" aria-label="Permalink to &quot;Setup&quot;">​</a></h3><p>Make sure you have a Teamscale license that includes Cppcheck Premium. This will ensure that Cppcheck Premium is an activated tool in Teamscale and becomes visible e.g. in C/C++ analysis profiles (see below).</p><ol><li>Contact <a href="mailto:support@cqse.eu" target="_blank" rel="noreferrer">Teamscale support</a> to request the Cppcheck Premium zip archive.</li><li>Extract the Cppcheck Premium zip archive to a path accessible by Teamscale. Please consider that Teamscale requires the whole folder, not just the Cppcheck Premium binary.</li><li>Install Python 3 for the current user or globally. Make it available in the system&#39;s <code>PATH</code> environment variable. Restart Teamscale.</li><li>Add the following JVM flag into <code>config/jvm.properties</code>: <code>-Dcom.teamscale.cppcheck-exe=&quot;&lt;absolute path to cppcheck binary&gt;&quot;</code></li><li>Windows only: If the Teamscale instance is <a href="./../installing-teamscale/installing-as-windows-service/">running as a service</a>, set an administrator account as logon user so that Teamscale can execute Cppcheck Premium. To do so, right-click on the Teamscale service &gt; “Properties”. On the <em>Log On</em> Tab, fill in the admin user details. <img src="`+n+'" alt="How to change the user that runs the Teamscale Service" width="781" height="491" data-zoom="true"></li><li>Verify the setup via Analysis Profile &gt; Tools &gt; Cppcheck Premium &gt; (internal) Verify setup <img src="'+l+`" alt="Verify the setup in the Analysis Profile" width="3252" height="618" data-zoom="true"></li></ol><h3 id="license" tabindex="-1">License <a class="header-anchor" href="#license" aria-label="Permalink to &quot;License&quot;">​</a></h3><p>In order to enable Cppcheck Premium in Teamscale, a Teamscale license that includes Cppcheck Premium is required. Please contact our <a href="mailto:support@cqse.eu" target="_blank" rel="noreferrer">support</a> for more information.</p><h2 id="findbugs-and-spotbugs" tabindex="-1">FindBugs and SpotBugs <a class="header-anchor" href="#findbugs-and-spotbugs" aria-label="Permalink to &quot;FindBugs and SpotBugs&quot;">​</a></h2><p><a href="http://findbugs.sourceforge.net/" target="_blank" rel="noreferrer">FindBugs</a> is an Open Source bug pattern search tool working on the byte code of Java programs. This means that in order to use FindBugs, you have to first compile the code.</p><p><a href="https://spotbugs.github.io/" target="_blank" rel="noreferrer">SpotBugs</a> is the successor of FindBugs, which is no longer maintained. Since SpotBugs reports are compatible with the FindBugs report format, they can be uploaded with the same analysis-tool name (<code>FINDBUGS</code>). To upload analysis results, you should use the <code>external-report</code> service as <a href="./../uploading-external-data/">described here</a>.</p><h2 id="flake8" tabindex="-1">Flake8 <a class="header-anchor" href="#flake8" aria-label="Permalink to &quot;Flake8&quot;">​</a></h2><p>While Flake8 is integrated as an internal analysis tool, Flake8 files are generally not shipped with Teamscale. Our docker-image distributions contain the correct Flake8 version, but distributions based on zip-files do not contain it. Instead, you will need to install Flake8 on your machine.</p><p>The required Flake8 and plugin versions are:</p><ul><li>flake8 6.1.0 <ul><li>includes mccabe 0.7.0, pycodestyle 2.11.1, and pyflakes 3.1.0</li></ul></li><li>flake8-bugbear 23.11.26</li></ul><p>In addition, you will need to have a Python 3 distribution installed with the <code>python3</code> executable on the <code>PATH</code>. This is included in our docker-image distributions as well.</p><h2 id="jacoco" tabindex="-1">JaCoCo <a class="header-anchor" href="#jacoco" aria-label="Permalink to &quot;JaCoCo&quot;">​</a></h2><p><a href="http://www.eclemma.org/jacoco/" target="_blank" rel="noreferrer">JaCoCo</a> is an Open Source code coverage tool for Java. Teamscale allows to upload XML coverage reports produced by JaCoCo. Please refer to <a href="./../setting-up-profiler-tga/java/">our Java test coverage guide</a> for instructions on how to set up JaCoCo for your tests.</p><p>To upload JaCoCo coverage data, you should use the external-report service as <a href="./../uploading-external-data/">described here</a>.</p><h2 id="cobertura" tabindex="-1">Cobertura <a class="header-anchor" href="#cobertura" aria-label="Permalink to &quot;Cobertura&quot;">​</a></h2><p><a href="http://cobertura.github.io/cobertura/" target="_blank" rel="noreferrer">Cobertura</a> is an Open Source code coverage tool for Java. Teamscale allows to upload XML coverage reports produced by Cobertura. You can generate an XML report with the Cobertura Ant task cobertura-report by setting the parameter format to xml as follows:</p><div class="language-xml vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">xml</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">&lt;</span><span style="--shiki-light:#22863A;--shiki-dark:#85E89D;">cobertura-report</span><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;"> format</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">=</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;xml&quot;</span></span>
<span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">	destdir</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">=</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;\${coveragereport.dir}&quot;</span></span>
<span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">	srcdir</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">=</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;\${src.dir}&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;"> /&gt;</span></span></code></pre></div><p>For further details on the usage of the Cobertura Ant tasks, please refer to the Cobertura user manual.</p><p>To upload Cobertura coverage data, you should use the <code>external-report</code> service as <a href="./../uploading-external-data/">described here</a>.</p><h2 id="gcov" tabindex="-1">gcov <a class="header-anchor" href="#gcov" aria-label="Permalink to &quot;gcov&quot;">​</a></h2><p>The tool <a href="http://gcc.gnu.org/onlinedocs/gcc/Gcov.html" target="_blank" rel="noreferrer">gcov</a> measures line coverage for C/C++ code compiled with the GCC compiler. Please see <a href="./../setting-up-profiler-tga/cpp/#gcc-and-lcov">our gcov how-to</a> for how to set up these tools and upload coverage to Teamscale.</p><h2 id="eslint" tabindex="-1">ESLint <a class="header-anchor" href="#eslint" aria-label="Permalink to &quot;ESLint&quot;">​</a></h2><p>While ESLint binaries are shipped with Teamscale, you will need to install the necessary <a href="https://nodejs.org/" target="_blank" rel="noreferrer">NodeJS</a> runtime on your machine. You will need to have the NodeJS binaries on the <code>PATH</code> and restart Teamscale before you can enable ESLint for your project.</p><p>The bundled ESLint distribution includes:</p><ul><li>@angular-eslint/eslint-plugin@17.1.1</li><li>@angular-eslint/eslint-plugin-template@17.1.1</li><li>@angular-eslint/template-parser@17.1.1</li><li>@typescript-eslint/eslint-plugin@5.59.9</li><li>@typescript-eslint/parser@5.59.9</li><li>eslint@8.42.0</li><li>eslint-plugin-jsx-a11y@6.8.0</li><li>eslint-plugin-react@7.32.2</li><li>eslint-plugin-security@2.1.0</li><li>typescript@5.1.3</li></ul><p>Teamscale comes with an ESLint configuration that defaults to ESLint&#39;s default values. You can still provide a custom ESLint config file in the analysis profile to adjust the rule&#39;s settings to your needs.</p><div class="tip custom-block"><p class="custom-block-title">Configuration file security</p><p>For security reasons, Teamscale only reads ESLint configuration files from Teamscale&#39;s <a href="./../../reference/administration-ts-installation/#configuring-teamscale">config directory</a>. Additionally, only <code>json</code>, <code>yml</code> and <code>yaml</code> are allowed as valid ESLint configuration file extension by default. To enable JavaScript configuration files (e.g., <code>.eslintrc.js</code>), you can set <code>-Dcom.teamscale.allow-executable-lint-config-file=true</code> in the <a href="./../../reference/administration-ts-installation/#jvm-settings-jvm-properties">jvm.properties file</a>.</p><p><strong>This is discouraged</strong> because it can potentially lead to code execution on the Teamscale server via the configuration file.</p></div><h2 id="sonarlint-for-javascript-typescript" tabindex="-1">SonarLint for JavaScript / TypeScript <a class="header-anchor" href="#sonarlint-for-javascript-typescript" aria-label="Permalink to &quot;SonarLint for JavaScript / TypeScript&quot;">​</a></h2><div class="info custom-block"><p class="custom-block-title">SonarLint for other languages</p><p>This section is only relevant for SonarLint <strong>for JavaScript / TypeScript</strong>. Analyzing other languages (e.g. Java or PHP) with SonarLint works without any additional setup.</p></div><p>Starting with Teamscale 9.7, SonarLint for JavaScript &amp; TypeScript is available as internal tool in Teamscale. This means SonarLint can be added to an analysis profile in the <em>Analysis Profile Editor</em> and Teamscale will automatically execute it for every commit.</p><p>When you are using <a href="./../../howto/installing-with-docker/">Teamscale with Docker</a> (recommended), no further setup is required.</p><p>When you are <strong>NOT</strong> running Teamscale&#39;s Docker image, executing the SonarLint for JavaScript / TypeScript binaries requires <a href="https://nodejs.org/" target="_blank" rel="noreferrer">NodeJS</a> <strong>in version 14.17 or higher</strong> on your machine. You will need to have the NodeJS binary on the <code>PATH</code> and restart Teamscale before you can enable checks by SonarLint for JavaScript / TypeScript for your project.</p><h2 id="tslint" tabindex="-1">TSLint <a class="header-anchor" href="#tslint" aria-label="Permalink to &quot;TSLint&quot;">​</a></h2><div class="warning custom-block"><p class="custom-block-title">Removed</p><p>TSLint support has been removed with Teamscale 8.2. Most of the TSLint checks are available via ESLint now. See <a href="https://github.com/typescript-eslint/typescript-eslint/blob/main/packages/eslint-plugin/ROADMAP.md" target="_blank" rel="noreferrer">the TSLint deprecation blog</a> for an overview of ESLint checks that replace TSLint checks.</p></div><h2 id="abaplint" tabindex="-1">abaplint <a class="header-anchor" href="#abaplint" aria-label="Permalink to &quot;abaplint&quot;">​</a></h2><p>AbapLint binaries (version @abaplint/cli@2.95.33) are now shipped and dedicated to being used with Teamscale.</p><p>Teamscale comes with an AbapLint configuration that defaults to AbapLint&#39;s default values. You can adjust the rules settings to your needs in the Analysis Profile Edit View.</p><p>AbapLint is able to analyze ABAP files according to the version of the ABAP language. As Teamscale communicates with SAP systems, it is now able to lint ABAP files providing the appropriate language version. If you desire to use a different language version, locate its corresponding version type from <a href="https://github.com/abaplint/abaplint/blob/main/packages/core/src/version.ts" target="_blank" rel="noreferrer">AbapLint</a> and provide it to the analysis profile using the option <code>ABAPLint language version</code>.</p><p>Additionally, you can import an AbapLint configuration file (<code>abaplint.json</code>) in the Analysis Profile View. This creates a new analysis profile that uses the settings from the configuration file.</p><p>If you like to use a fixed language version for the newly created analysis profile, you can provide it in the <code>version</code> field of the <code>syntax</code> section in the AbapLint configuration file. Otherwise, the field should be left blank. The value will be parsed into the option <code>ABAPLint language version</code> of the analysis profile.</p><div class="warning custom-block"><p class="custom-block-title">NodeJS</p><p>ABAPLint requires that <a href="https://nodejs.org/" target="_blank" rel="noreferrer">NodeJS version 16 or higher</a> is deployed on your system and globally available by putting it to the <code>PATH</code> variable.</p></div><h2 id="pc-lint-flexelint" tabindex="-1">PC-lint/FlexeLint <a class="header-anchor" href="#pc-lint-flexelint" aria-label="Permalink to &quot;PC-lint/FlexeLint&quot;">​</a></h2><p><a href="https://pclintplus.com/" target="_blank" rel="noreferrer">PC-lint</a> is a static analysis tool for C/C++ that covers a wide range of checks. To import PC-lint analysis results in Teamscale, you need to generate an XML report using the +xml parameter from PC-lint. For details, please refer to the documentation of PC-lint.</p><p>The check descriptions in Teamscale are up-to-date with PC-lint version 9.00L (i.e., Teamscale can import and display findings from a report generated by this PC-lint version).</p><h2 id="pylint" tabindex="-1">Pylint <a class="header-anchor" href="#pylint" aria-label="Permalink to &quot;Pylint&quot;">​</a></h2><p><a href="https://pylint.pycqa.org/" target="_blank" rel="noreferrer">Pylint</a> is an Open Source code analysis tool for Python working directly on the source code.</p><p>The check descriptions in Teamscale are up-to-date with pylint 3.0.3 (i.e., Teamscale can import and display findings from a report generated by this version). To import Pylint analysis results into Teamscale, you need to create the generated report using a special format. This can be achieved by using the following command line call:</p><div class="language-bash vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">bash</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">pylint</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> --score=no</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> --reports=no</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> --msg-template=</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&#39;line: {line}, messageId: {msg_id}, message: {msg}, absolutePath: {abspath}, messageName: {symbol}&#39;</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> /path/to/python/files</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;"> &gt;</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> report.json</span></span></code></pre></div><p>This command generates a plain text format which can be uploaded to Teamscale, either via the external uploads view for your project or simply using <code>curl</code> via the <a href="./../../reference/rest-api/">REST interface</a> (endpoints: <code>api/projects/{project}/external-analysis/session/*</code>). Please ensure to use the above message template without any changes.</p><p>Please note that while Pylint is capable of generating a JSON report, this cannot be used for Teamscale as does not contain all information necessary to seamlessly integrate the report into Teamscale.</p><h2 id="parasoft-c-c-test" tabindex="-1">Parasoft C/C++test <a class="header-anchor" href="#parasoft-c-c-test" aria-label="Permalink to &quot;Parasoft C/C++test&quot;">​</a></h2><p>The reports from Parasoft C/C++test are fully self-contained. The content and structure, however, depend completely on the configuration of the tool. Hence, before the first import of such a report, the findings need to be made known to Teamscale using the following steps:</p><ol><li>Create a new analysis profile (e.g., called <code>CppWithParasoft</code>) with Parasoft C/C++test enabled in the tools section</li><li>Call the following service to upload the report and update the analysis profile:</li></ol><div class="language-bash vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">bash</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">curl</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> -X</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> POST</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> -F</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> report=@parasoft.xml</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> &#39;http://&lt;teamscale-url&gt;/api/external-findings/descriptions/from-parasoft-report?analysis-profile=CppWithParasoft&#39;</span></span></code></pre></div><ol start="3"><li>The analysis profile should now be updated with rules and can be adjusted if needed</li><li>Create a project with the updated analysis profile</li></ol><h2 id="powershell-script-analyzer-psscriptanalyzer" tabindex="-1">PowerShell Script Analyzer (PSScriptAnalyzer) <a class="header-anchor" href="#powershell-script-analyzer-psscriptanalyzer" aria-label="Permalink to &quot;PowerShell Script Analyzer (PSScriptAnalyzer)&quot;">​</a></h2><p>While the PowerShell Script Analyzer is integrated as an internal analysis tool, its binaries are generally not shipped with Teamscale. Our docker-image distributions contain the correct version of PowerShellScriptAnalyzer, but distributions based on zip-files do not contain the tool. Instead, you will need to install <a href="https://learn.microsoft.com/en-us/powershell/scripting/install/installing-powershell" target="_blank" rel="noreferrer">PowerShell</a> and <a href="https://learn.microsoft.com/de-de/powershell/utility-modules/psscriptanalyzer/overview?view=ps-modules#installing-psscriptanalyzer" target="_blank" rel="noreferrer">PSScriptAnalyzer version 1.21.0</a> on your Teamscale server. More details are <a href="./../../troubleshooting/#wrong-version-of-psscriptanalyzer">described here</a>.</p><h2 id="xcode-test-coverage" tabindex="-1">XCode Test Coverage <a class="header-anchor" href="#xcode-test-coverage" aria-label="Permalink to &quot;XCode Test Coverage&quot;">​</a></h2><p>Test coverage for XCode projects is recorded in an XCResult bundle in a binary format. Teamscale supports importing the contained line-based test coverage by exporting it in a textual format using the <code>xccov</code> command line tool. For XCode 13.3 and above the coverage can be exported in a textual format using the following command:</p><div class="language-bash vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">bash</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">xcrun</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> xccov</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> view</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> --archive</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> path/to/some.xcresult</span></span></code></pre></div><p>For XCode 13.2 and below the XCode tooling cannot produce a comprehensive report with line coverage information for all files in a project, the following shell script must be used to obtain a coverage report that can be imported into Teamscale:</p><div class="language-bash vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">bash</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#6A737D;--shiki-dark:#6A737D;">#!/bin/bash</span></span>
<span class="line"><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">if</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;"> [ </span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">$#</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;"> -eq</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> 0</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;"> ]</span></span>
<span class="line"><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">  then</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">  echo</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> &quot;Please provide path to xccovarchive directory&quot;</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">  exit</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> 1</span></span>
<span class="line"><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">fi</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">archive</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">=</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">$1</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;</span></span>
<span class="line"></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">coverage</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">=</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;&quot;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">files</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">=</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">$(</span><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">xcrun</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> xccov</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> view</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> --archive</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> --file-list</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> &quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">$archive</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">)</span></span>
<span class="line"><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">while</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> read</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> -r</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> file</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">; </span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">do</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">  coverage</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">+=</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">$file</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">  coverage</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">+=</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">$&#39;</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">\\n</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&#39;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">  coverage</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">+=</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;$(</span><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">xcrun</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> xccov view </span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">--archive</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> &quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">$archive</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot; </span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">--file</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> &quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">$file</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;):&quot;</span></span>
<span class="line"><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">  coverage</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">+=</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">$&#39;</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">\\n</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&#39;</span></span>
<span class="line"><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">done</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;"> &lt;&lt;&lt;</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> &quot;</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">$files</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">&quot;</span></span>
<span class="line"><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;">echo</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> &quot;\${</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">coverage</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">}&quot;</span></span></code></pre></div><p>In both cases the command will output the coverage report to standard out. You can pipe the output into a file which can then be uploaded via the REST API as <a href="./../uploading-external-data/">described here</a>.</p><p>Note that the <a href="https://github.com/cqse/teamscale-upload" target="_blank" rel="noreferrer">Teamscale Upload</a> tool provides an easy to use automatic conversion of the XCResult bundle. Any <code>*.xcresult</code>, <code>*.xcresult.tar</code>, <code>*.xcresult.tar.gz</code> or <code>*.xcresult.tgz</code> file can be passed as a report with format <code>XCODE</code> to the tool and it will perform automatic conversion to the right format before upload.</p><h3 id="xcode-xctest-test-execution-data" tabindex="-1">XCode XCTest test execution data <a class="header-anchor" href="#xcode-xctest-test-execution-data" aria-label="Permalink to &quot;XCode XCTest test execution data&quot;">​</a></h3><p>Besides coverage, XCTest result files (<code>*.xcresult</code>) also contain test execution data. To import this data to Teamscale, the following command can be used to generate a report in JSON format:</p><div class="language-bash vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">bash</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">xcrun</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> xcresulttool</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> get</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> --path</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;"> &lt;</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">xcresult-fil</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">e</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">&gt;</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> --format</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> json</span></span></code></pre></div><p>The generated <code>*.json</code> file should contain an explicit <em>testsRef</em> ID, e.g. <code>0~pYxLsSwT2harDbBkwHOemYmrig4tejMoZIDzYaRhN1_YDV6VNk01K24YhzwGOQTd5yIr4raTPhFhE3DPlKwG_Q==</code>. This ID should be used in the following script to obtain the final report file:</p><div class="language-bash vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">bash</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">xcrun</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> xcresulttool</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> get</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> --path</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;"> &lt;</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;">xcresult-fil</span><span style="--shiki-light:#24292E;--shiki-dark:#E1E4E8;">e</span><span style="--shiki-light:#D73A49;--shiki-dark:#F97583;">&gt;</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> --format</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> json</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> --id</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> &quot;&lt;id&gt;&quot;</span></span></code></pre></div><p>This resulting <code>*.json</code> file can then be uploaded to Teamscale as a XCode JSON test execution report. This can be done analogously to test execution reports <a href="./../providing-testwise-coverage/#maven-and-junit-5">as described here</a>.</p><div class="info custom-block"><p class="custom-block-title">Mapping of status &quot;Expected Failure&quot;</p><p>Currently Teamscale does not support the test execution status &quot;Expected Failure&quot; as a separate status category. The test cases with this outcome are stored as &quot;Successful&quot;. The reason is that if a test case fails expectedly, then it behaves as specified.</p></div><h2 id="bullseyecoverage" tabindex="-1">BullseyeCoverage <a class="header-anchor" href="#bullseyecoverage" aria-label="Permalink to &quot;BullseyeCoverage&quot;">​</a></h2><p>See our <a href="./../../howto/setting-up-profiler-tga/cpp/#bullseye">detailed guide on C/C++ test coverage</a>.</p><h2 id="swiftlint" tabindex="-1">SwiftLint <a class="header-anchor" href="#swiftlint" aria-label="Permalink to &quot;SwiftLint&quot;">​</a></h2><p>SwiftLint is a tool to check Swift code for adherence to style guide and conventions. While SwiftLint is executed directly by Teamscale, the binaries are not shipped with the Teamscale distribution. To enable SwiftLint, you need to install SwiftLint on the Teamscale analysis server and ensure that the <code>swiftlint</code> executable is on the path.</p><h2 id="semgrep" tabindex="-1">Semgrep <a class="header-anchor" href="#semgrep" aria-label="Permalink to &quot;Semgrep&quot;">​</a></h2><p>Semgrep is integrated into Teamscale as an internal analysis tool. Our docker-image distributions contain the correct semgrep version, but distributions based on zip-files do not contain it. Instead, you will need to install semgrep on your machine. The required semgrep version is 1.92.0.</p><h2 id="dart-lint" tabindex="-1">Dart Lint <a class="header-anchor" href="#dart-lint" aria-label="Permalink to &quot;Dart Lint&quot;">​</a></h2><p>The Dart linter is now integrated as an internal analysis tool with Teamscale. Our docker-image distributions contain the correct Dart SDK version, but distributions based on zip-files do not contain it. Instead, you will need to install Dart SDK on your machine, in order to use it, ensure you have version 3.5 or higher installed.</p><h2 id="golangci-lint" tabindex="-1">Golangci-lint <a class="header-anchor" href="#golangci-lint" aria-label="Permalink to &quot;Golangci-lint&quot;">​</a></h2><p>Golangci-lint is a fast linters runner for the Go language. It is integrated into Teamscale as an internal analysis tool. Docker-image distributions of Teamscale contain Golangci-lint but distributions based on zip-files don&#39;t. If using these distributions, it is required to install Golangci-lint and the Go language on the machine and make them available on the system&#39;s path.</p><h2 id="phpstan" tabindex="-1">PHPStan <a class="header-anchor" href="#phpstan" aria-label="Permalink to &quot;PHPStan&quot;">​</a></h2><p>PHPStan is now integrated as an internal analysis tool with Teamscale. PHPStan requires PHP 7.2 or higher. In case your project manages its dependencies via <a href="https://getcomposer.org/" target="_blank" rel="noreferrer">composer</a>, Teamscale will try to resolve these dependencies during analysis. For this, composer version 2.2 or higher is required. Our docker-image distributions contain the latest PHP and composer version, but distributions based on zip-files do not contain it. Instead, you will need to install PHP (and composer) on your machine.</p><div class="info custom-block"><p class="custom-block-title">Rule Levels</p><p>The idea of PHPStan is to use a so-called &quot;Rule Level&quot; instead of specifying the checks to execute. The higher the level, the more stricter checks are enabled. By default, Teamscale uses the max level and filters out any findings of disabled checks. However, if required, it is possible to change the rule level Teamscale uses in the advanced settings of the analysis profile. Please note, in this case, PHPStan does not execute higher level checks, even though they are enabled in the analysis profile.</p></div>`,105)])])}const y=a(o,[["render",r]]);export{g as __pageData,y as default};
