# Description
Checks that usages of `CALL TRANSACTION` contain an authority-check.

# Extended Information
https://docs.abapopenchecks.org/checks/54/

# Examples
**Bad example**
```abap
CALL TRANSACTION 'FOO'.
```

**Good example**
```abap
TRY.
    CALL TRANSACTION 'FOO' WITH AUTHORITY-CHECK.
  CATCH cx_sy_authorization_error.
ENDTRY.
```

---
For more information visit the [official ABAPLint rule documentation](https://rules.abaplint.org/call_transaction_authority_check) <br>
