# Description
Constructor must be placed in the public section, even if the class is not `CREATE PUBLIC`.

# Extended Information
This only applies to global classes.

https://github.com/SAP/styleguides/blob/main/clean-abap/CleanABAP.md#if-your-global-class-is-create-private-leave-the-constructor-public
https://help.sap.com/doc/abapdocu_751_index_htm/7.51/en-US/abeninstance_constructor_guidl.htm

# Clean ABAP Code Style Guide
```ABAP
CLASS /clean/some_api DEFINITION PUBLIC FINAL CREATE PRIVATE.
  PUBLIC SECTION.
    METHODS constructor.
```

We agree that this contradicts itself.
However, according to the article
[_Instance Constructor_ of the ABAP Help](https://help.sap.com/doc/abapdocu_latest_index_htm/latest/en-US/abeninstance_constructor_guidl.htm),
specifying the `CONSTRUCTOR` in the `PUBLIC SECTION` is required to guarantee correct compilation and syntax validation.

This applies only to global classes.
In local classes, make the constructor private, as it should be.

---
For more information visit the [official ABAPLint rule documentation](https://rules.abaplint.org/constructor_visibility_public) <br>
The contents within section `Clean ABAP Code Style Guide` were copied from the [official SAP Code Style Guides repository](https://github.com/SAP/styleguides/).
