# Description
Detects usage of call method when functional style calls can be used.

# Extended Information
https://github.com/SAP/styleguides/blob/main/clean-abap/CleanABAP.md#prefer-functional-to-procedural-calls
https://docs.abapopenchecks.org/checks/07/

# Examples
**Bad example**
```abap
CALL METHOD zcl_class=>method( ).
CALL METHOD cl_abap_typedescr=>describe_by_name
  EXPORTING
    p_name         = 'NAME'
  RECEIVING
    p_descr_ref    = lr_typedescr
  EXCEPTIONS
    type_not_found = 1
    OTHERS         = 2.
```

**Good example**
```abap
zcl_class=>method( ).
cl_abap_typedescr=>describe_by_name(
  EXPORTING
    p_name         = 'NAME'
  RECEIVING
    p_descr_ref    = lr_typedescr
  EXCEPTIONS
    type_not_found = 1
    OTHERS         = 2 ).
```

# Clean ABAP Code Style Guide
```ABAP
modify->update( node           = /clean/my_bo_c=>node-item
                key            = item->key
                data           = item
                changed_fields = changed_fields ).
```

instead of the needlessly longer

```ABAP
" anti-pattern
CALL METHOD modify->update
  EXPORTING
    node           = /dirty/my_bo_c=>node-item
    key            = item->key
    data           = item
    changed_fields = changed_fields.
```

If dynamic typing forbids functional calls, resort to the procedural style

```ABAP
CALL METHOD modify->(method_name)
  EXPORTING
    node           = /clean/my_bo_c=>node-item
    key            = item->key
    data           = item
    changed_fields = changed_fields.
```

---
For more information visit the [official ABAPLint rule documentation](https://rules.abaplint.org/functional_writing) <br>
The contents within section `Clean ABAP Code Style Guide` were copied (except for text that cross-references other rules) from the [official SAP Code Style Guides repository](https://github.com/SAP/styleguides/).
