### SCS0033 - Password Complexity 

PasswordValidator should have at least two requirements for better security (RequiredLength, RequireDigit, RequireLowercase, RequireUppercase and/or RequireNonLetterOrDigit).

#### Risk

Weak password can be guessed or brute-forced.

#### Vulnerable Code

```cs
PasswordValidator pwdv = new PasswordValidator
{
    RequiredLength = 6,
};

```

#### Solution

```cs
PasswordValidator pwdv = new PasswordValidator
{
    RequiredLength = 8,
    RequireNonLetterOrDigit = true,
    RequireDigit = true,
    RequireLowercase = true,
    RequireUppercase = true,
};

```

#### References

[CWE-521: Weak Password Requirements](https://cwe.mitre.org/data/definitions/521.html)  
[MSDN: ASP.NET Identity PasswordValidator Class](https://msdn.microsoft.com/en-us/library/microsoft.aspnet.identity.passwordvalidator.aspx)

## Other

Source: [Security Code Scan](https://security-code-scan.github.io/#Rules)