<h2>Why is this an issue?</h2>
<p>Re-assigning a variable to itself is a defect as it has no actual effect and indicates meaning to do something else. It usually means that:</p>
<ul>
  <li> The statement is redundant and should be removed </li>
  <li> The re-assignment is a mistake, and another value or variable was intended for the assignment instead </li>
</ul>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>
<pre data-diff-id="1" data-diff-type="noncompliant">
public class Choice {
    private bool selected;

    public void MakeChoice(bool selected)
    {
        selected = selected; // Noncompliant
    }
}
</pre>
<h4>Compliant solution</h4>
<pre data-diff-id="1" data-diff-type="compliant">
public class Choice {
    private bool selected;

    public void MakeChoice(bool selected)
    {
        this.selected = selected; // Compliant
    }
}
</pre>
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> Microsoft Learn - <a href="https://learn.microsoft.com/en-us/dotnet/csharp/misc/cs1717">Compiler Warning (level 3) CS1717</a> </li>
</ul>

