<p>This rule raises an issue each time a <code>static</code> field is updated from a non-static method or property.</p>
<h2>Why is this an issue?</h2>
<p>Updating a <code>static</code> field from a non-<code>static</code> method introduces significant challenges and potential bugs. Multiple class
instances and threads can access and modify the <code>static</code> field concurrently, leading to unintended consequences for other instances or
threads (unexpected behavior, <a href="https://www.c-sharpcorner.com/UploadFile/1d42da/race-conditions-in-threading-C-Sharp/">race conditions</a> and
synchronization problems).</p>
<pre>
class MyClass
{
  private static int count = 0;

  public void DoSomething()
  {
    //...
    count++;  // Noncompliant: make the enclosing instance property 'static' or remove this set on the 'static' field.
  }
}

interface MyInterface
{
  private static int count = 0;

  public void DoSomething()
  {
    //...
    count++;  // Noncompliant: remove this set, which updates a 'static' field from an instance method.
  }
}
</pre>
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> <a href="https://learn.microsoft.com/en-us/dotnet/csharp/programming-guide/classes-and-structs/static-classes-and-static-class-members">Static
  Classes and Static Class Members</a> </li>
  <li> <a href="https://learn.microsoft.com/en-us/dotnet/standard/threading/using-threads-and-threading">Using threads and threading</a> </li>
</ul>
<h3>Articles &amp; blog posts</h3>
<ul>
  <li> <a href="https://www.c-sharpcorner.com/UploadFile/1d42da/race-conditions-in-threading-C-Sharp/">Race Conditions in C#</a> </li>
</ul>
<h3>Standards</h3>
<ul>
  <li> STIG Viewer - <a href="https://stigviewer.com/stig/application_security_and_development/2023-06-08/finding/V-222567">Application Security and
  Development: V-222567</a> - The application must not be vulnerable to race conditions. </li>
</ul>

