<h2>Why is this an issue?</h2>
<p>Private methods are intended for use only within their scope. If these methods return values that are not utilized by any calling functions, it
indicates that the return operation is unnecessary. Removing such returns can enhance both efficiency and code clarity.</p>
<h3>Noncompliant code example</h3>
<pre>
class SomeClass
{
     private int PrivateMethod() =&gt; 42;

     public void PublicMethod()
     {
          PrivateMethod(); // Noncompliant: the result of PrivateMethod is not used
     }
}
</pre>

