<h2>Why is this an issue?</h2>
<p>There’s no point in checking a variable against the value you’re about to assign it. Save the cycles and lines of code, and simply perform the
assignment.</p>
<h3>Noncompliant code example</h3>
<pre>
if (x != a)  // Noncompliant; why bother?
{
    x = a;
}
</pre>
<h3>Compliant solution</h3>
<pre>
x = a;
</pre>
<h3>Exceptions</h3>
<p>Properties and checks inside setters are excluded from this rule because they could have side effects and removing the check could lead to
undesired side effects.</p>
<pre>
if (MyProperty != a)
{
    MyProperty = a; // Compliant because the setter could be expensive call
}
</pre>
<pre>
private int myField;
public int SomeProperty
{
    get
    {
        return myField;
    }
    set
    {
        if (myField != value)
        {
            myField = value;
        }
    }
}
</pre>

