<h2>Why is this an issue?</h2>
<p>String representations of URIs or URLs are prone to parsing and encoding errors which can lead to vulnerabilities. The <code>System.Uri</code>
class is a safe alternative and should be preferred.</p>
<p>This rule raises an issue when a called method has a string parameter with a name containing "uri", "Uri", "urn", "Urn", "url" or "Url" and the
declaring type contains a corresponding overload that takes a <code>System.Uri</code> as a parameter.</p>
<p>When there is a choice between two overloads that differ only regarding the representation of a URI, the user should choose the overload that takes
a <code>System.Uri</code> argument.</p>
<h3>Noncompliant code example</h3>
<pre>
using System;

namespace MyLibrary
{
   public class Foo
   {
      public void FetchResource(string uriString) { }
      public void FetchResource(Uri uri) { }

      public string ReadResource(string uriString, string name, bool isLocal) { }
      public string ReadResource(Uri uri, string name, bool isLocal) { }

      public void Main() {
        FetchResource("http://www.mysite.com"); // Noncompliant
        ReadResource("http://www.mysite.com", "foo-resource", true); // Noncompliant
      }
   }
}
</pre>
<h3>Compliant solution</h3>
<pre>
using System;

namespace MyLibrary
{
   public class Foo
   {
      public void FetchResource(string uriString) { }
      public void FetchResource(Uri uri) { }

      public string ReadResource(string uriString, string name, bool isLocal) { }
      public string ReadResource(Uri uri, string name, bool isLocal) { }

      public void Main() {
        FetchResource(new Uri("http://www.mysite.com"));
        ReadResource(new Uri("http://www.mysite.com"), "foo-resource", true);
      }
   }
}
</pre>

