<h2>Why is this an issue?</h2>
<p>When a type name matches the name of a publicly defined namespace, for instance one in the .NET framework class library, it leads to confusion and
makes the library that much harder to use.</p>
<p>This rule raises an issue when a name of a public type matches the name of a .NET Framework namespace, or a namespace of the project assembly, in a
case-insensitive comparison.</p>
<h3>Noncompliant code example</h3>
<pre>
using System;

namespace MyLibrary
{
  public class Text   // Noncompliant: Collides with System.Text
  {
  }
}
</pre>
<h3>Compliant solution</h3>
<pre>
using System;

namespace MyLibrary
{
  public class MyText
  {
  }
}
</pre>

