﻿## SA1116

<table>
<tr>
  <td>TypeName</td>
  <td>SA1116SplitParametersMustStartOnLineAfterDeclaration</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1116</td>
</tr>
<tr>
  <td>Category</td>
  <td>Readability Rules</td>
</tr>
</table>

## Cause

The parameters to a C# method or indexer call or declaration span across multiple lines, but the first parameter does not start on the line after the opening bracket.

## Rule description

A violation of this rule occurs when the parameters to a method or indexer span across multiple lines, but the first parameter does not start on the line after the opening bracket. For example:

```csharp
public string JoinName(string first, 
    string last)
{
}
```

The parameters should begin on the line after the declaration, whenever the parameter span across multiple lines:

```csharp
public string JoinName(
    string first, 
    string last)
{
}
```

## How to fix violations

To fix a violation of this rule, ensure that the first parameter starts on the line after the opening bracket, or place all parameters on the same line if the parameters are not too long.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.ReadabilityRules", "SA1116:SplitParametersMustStartOnLineAfterDeclaration", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1116 // SplitParametersMustStartOnLineAfterDeclaration
#pragma warning restore SA1116 // SplitParametersMustStartOnLineAfterDeclaration
```
