﻿## SA1117

<table>
<tr>
  <td>TypeName</td>
  <td>SA1117ParametersMustBeOnSameLineOrSeparateLines</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1117</td>
</tr>
<tr>
  <td>Category</td>
  <td>Readability Rules</td>
</tr>
</table>

## Cause

The parameters to a C# method or indexer call or declaration are not all on the same line or each on a separate line.

## Rule description

A violation of this rule occurs when the parameters to a method or indexer are not all on the same line or each on its own line. For example:

```csharp
public string JoinName(string first, string middle,
    string last)
{
}
```

The parameters can all be placed on the same line:

```csharp
public string JoinName(string first, string middle, string last)
{
}

public string JoinName(
    string first, string middle, string last)
{
}
```

Alternatively, each parameter can be placed on its own line:

```csharp
public string JoinName(
    string first, 
    string middle, 
    string last)
{
}
```

## How to fix violations

To fix a violation of this rule, place all parameters on the same line, or place each parameter on its own line.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.ReadabilityRules", "SA1117:ParametersMustBeOnSameLineOrSeparateLines", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1117 // ParametersMustBeOnSameLineOrSeparateLines
#pragma warning restore SA1117 // ParametersMustBeOnSameLineOrSeparateLines
```
