## SA1127

<table>
<tr>
  <td>TypeName</td>
  <td>SA1127GenericTypeConstraintsMustBeOnOwnLine</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1127</td>
</tr>
<tr>
  <td>Category</td>
  <td>Readability Rules</td>
</tr>
</table>

:memo: This rule is new for StyleCop Analyzers, and was not present in StyleCop Classic.

## Cause

A generic constraint on a type or method declaration is on the same line as the declaration, within a C# code file.

## Rule description

A violation of this rule occurs whenever the code contains one or more `where` clauses containing generic type constraints on the same line as the type or method declaration itself.

For example, the following code would produce two violations of this rule:

```csharp
private void Method<T, R>() where T : class where R : class, new()
{
}
```

The following code would not produce any violations:

```csharp
private void Method<T, R>()
    where T : class
    where R : class, new()
{
}
```

## How to fix violations

To fix a violation of this rule, move each `where` clause to its own line.

## How to suppress violations

```csharp
#pragma warning disable SA1127 // Generic type constraints should be on their own line
private void Method<T>() where T : class
#pragma warning restore SA1127 // Generic type constraints should be on their own line
{
    // method body...
}
```
