﻿## SA1646

<table>
<tr>
  <td>TypeName</td>
  <td>SA1646IncludedDocumentationXPathDoesNotExist</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1646</td>
</tr>
<tr>
  <td>Category</td>
  <td>Documentation Rules</td>
</tr>
</table>

:warning: This rule has been intentionally omitted from StyleCop Analyzers. See [KnownChanges.md](KnownChanges.md) for
additional information.

## Cause

An included Xml documentation link contains an invalid path.

## Rule description

C# syntax provides a mechanism for inserting documentation for classes and elements directly into the code, through the use of Xml documentation headers. For an introduction to these headers and a description of the header syntax, see the following article: [https://docs.microsoft.com/en-us/dotnet/csharp/programming-guide/xmldoc/xml-documentation-comments.](https://docs.microsoft.com/en-us/dotnet/csharp/programming-guide/xmldoc/xml-documentation-comments)

As an alternative to authoring documentation directly within the code file, it is possible to place documentation for multiple elements within a separate Xml file, and then reference a section of that file within an element's documentation header. This causes the compiler to import the documentation for that element from the included document. For example:

```csharp
/// <include file="IncludedDocumentation.xml" path="root/EnabledMethodDocs" />
public bool Enabled(bool true)
{
}
```

A violation of this rule occurs when the path attribute does not link to a valid path within the included documentation file.

## How to fix violations

To fix a violation of this rule, correct the value of the path attribute to point to a valid path within the file.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.DocumentationRules", "SA1646:IncludedDocumentationXPathDoesNotExist", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1646 // IncludedDocumentationXPathDoesNotExist
#pragma warning restore SA1646 // IncludedDocumentationXPathDoesNotExist
```
