<h2>Why is this an issue?</h2>
<p>Shared naming conventions allow teams to collaborate effectively. This rule raises an issue when an open curly brace is not placed at the end of a
line of code.</p>
<h3>Noncompliant code example</h3>

```java
if(condition)
{
  doSomething();
}
```
<h3>Compliant solution</h3>

```java
if(condition) {
  doSomething();
}
```
<h3>Exceptions</h3>
<p>When blocks are inlined (left and right curly braces on the same line), no issue is triggered.</p>

```java
if(condition) {doSomething();}
```