<h2>Why is this an issue?</h2>
<p>The purpose of Java packages is to give structure to your project. A structure helps to mentally break down a project into smaller parts,
simplifying readers' understanding of how components are connected and how they interact.</p>
<p>By convention, the source files' directory structure should replicate the project’s package structure. This is for the following reasons:</p>
<ol>
  <li> The mapping between the package name and the location of the source file of a class is straightforward. That is, the path to the source file is
  easier to find for a given fully qualified class name. </li>
  <li> If two different structures are applied to the same project - one to the packages but another to the source file directories - this confuses
  developers while not providing any benefit. </li>
  <li> The directory structure of the class files generated by the compiler will match the package structure, no matter the source file’s directory.
  It would not make sense to have one directory structure for the generated class files but a different one for the associated source files. </li>
</ol>
<p>Similarly, a source directory should not have the character <code>.</code> in its name, as this would make it impossible to match the directory to
the package structure.</p>
<h2>How to fix it</h2>
<p>Either move the source file so that the relative file path within the source directory matches the package name, or change the package name so that
it matches the relative file path.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```java
// file: src/main/foo/Fubar.java
package com.foo.bar;

class Fubar {
}
```
<h4>Compliant solution</h4>

```java
// file: src/main/com/foo/bar/Fubar.java
package com.foo.bar;

class Fubar {
}
```

```java
// file: src/main/foo/Fubar.java
package foo;

class Fubar {
}
```
<h2>Resources</h2>
<h3>Articles &amp; blog posts</h3>
<ul>
  <li> <a href="https://www.baeldung.com/java-declared-expected-package-error">Baeldung - Fixing the "Declared package does not match the expected
  package" Error</a> </li>
  <li> <a href="https://www.baeldung.com/java-file-vs-file-path-separator">Stackoverflow - Why do java source files require package declarations?</a>
  </li>
  <li> <a
  href="https://www.tutorialspoint.com/what-are-the-best-practices-to-keep-in-mind-while-using-packages-in-java#:~:text=Naming%20conventions%20and%20best%20practices%20for%20packages">tutorialspoint - What are the best practices to keep in mind while using packages in Java?</a> </li>
</ul>