<h2>Why is this an issue?</h2>
<p>Declaring multiple variables on one line is difficult to read.</p>
<h3>Noncompliant code example</h3>

```java
class MyClass {

  private int a, b;

  public void method(){
    int c; int d;
  }
}
```
<h3>Compliant solution</h3>

```java
class MyClass {

  private int a;
  private int b;

  public void method(){
    int c;
    int d;
  }
}
```
<h2>Resources</h2>
<ul>
  <li> <a href="https://wiki.sei.cmu.edu/confluence/x/YTZGBQ">CERT, DCL52-J.</a> - Do not declare more than one variable per declaration </li>
  <li> <a href="https://wiki.sei.cmu.edu/confluence/x/EtcxBQ">CERT, DCL04-C.</a> - Do not declare more than one variable per declaration </li>
</ul>