<h2>Why is this an issue?</h2>
<p>Fields marked as <code>transient</code> in a <code>Serializable</code> class will be ignored during serialization and consequently not written out
to a file (or stream).</p>
<p>This can be useful in situations such as where the content of a field can be recomputed from other fields. To reduce the output size, this field
can be marked as <code>transient</code> and recomputed when a given object is deserialized.</p>
<p>Since <code>transient</code> is very specific to classes that implement <code>Serializable</code>, it is superfluous in classes that do not.</p>
<p>This rule raises an issue when a field is marked as <code>transient</code>, even though the containing class does not implement
<code>Serializable</code>.</p>
<h2>How to fix it</h2>
<p>Ask yourself whether this class should be serializable. If yes, ensure it implements <code>Serializable</code> and provides any additional logic
required to serialize and deserialize an instance of this type. Otherwise, remove the <code>transient</code> modifier from this field.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```java
class Vegetable {
  private transient Season ripe; // Noncompliant, the "Vegetable" class does not implement "Serializable" but the field is marked as "transient"
  // ...
}
```
<h4>Compliant solution</h4>

```java
class Vegetable {
  private Season ripe; // Compliant, the field is not marked as "transient"
  // ...
}
```
<h2>Resources</h2>
<ul>
  <li> <a href="https://www.baeldung.com/java-transient-keyword">Baeldung - The transient Keyword in Java</a> </li>
</ul>