<h2>Why is this an issue?</h2>
<p>Overriding a parent class method prevents that method from being called unless an explicit <code>super</code> call is made in the overriding
method. In some cases, not calling the parent method is fine. However, <code>setUp</code> and <code>tearDown</code> provide some shared logic that is
called before all test cases. This logic may change over the lifetime of your codebase. To make sure that your test cases are set up and cleaned up
consistently, your overriding implementations of <code>setUp</code> and <code>tearDown</code> should call the parent implementations explicitly.</p>
<h2>How to fix it</h2>
<p>Add an explicit call to <code>super.setUp()</code> and <code>super.tearDown()</code> in the overriding methods.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```java
public class MyClassTest extends MyAbstractTestCase {

  private MyClass myClass;

  @Override
  protected void setUp() throws Exception {  // Noncompliant
    myClass = new MyClass();
  }
}
```
<h4>Compliant solution</h4>

```java
public class MyClassTest extends MyAbstractTestCase {

  private MyClass myClass;

  @Override
  protected void setUp() throws Exception {
    super.setUp();
    myClass = new MyClass();
  }
}
```