<h2>Why is this an issue?</h2>
<p>Referencing a static member of a subclass from its parent during class initialization, makes the code more fragile and prone to future bugs. The
execution of the program will rely heavily on the order of initialization of classes and their static members.</p>
<h3>What is the potential impact?</h3>
<p>This could create what is known as an "initialization cycle", or even a deadlock in some extreme cases. Additionally, if the order of the static
class members is changed, the behavior of the program might change. These issues can be very hard to diagnose so it is highly recommended to avoid
creating this kind of dependencies.</p>
<h3>Noncompliant code example</h3>

```java
class Parent {
  static int field1 = Child.method(); // Noncompliant
  static int field2 = 42;

  public static void main(String[] args) {
    System.out.println(Parent.field1); // will display "0" instead of "42"
  }
}

class Child extends Parent {
  static int method() {
    return Parent.field2;
  }
}
```
<h2>Resources</h2>
<ul>
  <li> CERT - <a href="https://wiki.sei.cmu.edu/confluence/display/java/DCL00-J.+Prevent+class+initialization+cycles">DCL00-J. Prevent class
  initialization cycles</a> </li>
  <li> <a href="https://docs.oracle.com/javase/specs/jls/se17/html/jls-12.html#jls-12.4">Section 12.4: Initialization of Classes and Interfaces</a> -
  Java Language Specification </li>
</ul>